/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.predicate.Primitives;
import com.facebook.presto.common.predicate.Utils;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ConstantExpression
extends RowExpression {
    private final Object value;
    private final Type type;

    public ConstantExpression(Object value, Type type) {
        Objects.requireNonNull(type, "type is null");
        if (value != null && !Primitives.wrap((Class)type.getJavaType()).isInstance(value)) {
            throw new IllegalArgumentException(String.format("Object '%s' does not match type %s", value, type.getJavaType()));
        }
        this.value = value;
        this.type = type;
    }

    @JsonCreator
    public static ConstantExpression createConstantExpression(@JsonProperty(value="valueBlock") Block valueBlock, @JsonProperty(value="type") Type type) {
        return new ConstantExpression(Utils.blockToNativeValue((Type)type, (Block)valueBlock), type);
    }

    @JsonProperty
    public Block getValueBlock() {
        return Utils.nativeValueToBlock((Type)this.type, (Object)this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantExpression other = (ConstantExpression)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstant(this, context);
    }
}

