/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.SchemaTableName;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConnectorMaterializedViewDefinition {
    private final String originalSql;
    private final String schema;
    private final String table;
    private final List<SchemaTableName> baseTables;
    private final Optional<String> owner;
    private final List<ColumnMapping> columnMappings;
    private final List<SchemaTableName> baseTablesOnOuterJoinSide;
    private final Optional<List<String>> validRefreshColumns;

    @JsonCreator
    public ConnectorMaterializedViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="schema") String schema, @JsonProperty(value="table") String table, @JsonProperty(value="baseTables") List<SchemaTableName> baseTables, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="columnMapping") List<ColumnMapping> columnMappings, @JsonProperty(value="baseTablesOnOuterJoinSide") List<SchemaTableName> baseTablesOnOuterJoinSide, @JsonProperty(value="validRefreshColumns") Optional<List<String>> validRefreshColumns) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.baseTables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(baseTables, "baseTables is null")));
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.columnMappings = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(columnMappings, "columnMappings is null")));
        this.baseTablesOnOuterJoinSide = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(baseTablesOnOuterJoinSide, "baseTablesOnOuterJoinSide is null")));
        this.validRefreshColumns = Objects.requireNonNull(validRefreshColumns, "validRefreshColumns is null").map(columns -> Collections.unmodifiableList(new ArrayList(columns)));
    }

    @JsonIgnore
    public ConnectorMaterializedViewDefinition(String originalSql, String schema, String table, List<SchemaTableName> baseTables, Optional<String> owner, Map<String, Map<SchemaTableName, String>> originalColumnMapping, Map<String, Map<SchemaTableName, String>> nonNullColumnMappings, List<SchemaTableName> baseTablesOnOuterJoinSide, Optional<List<String>> validRefreshColumns) {
        this(originalSql, schema, table, baseTables, owner, ConnectorMaterializedViewDefinition.convertFromMapToColumnMappings(Objects.requireNonNull(originalColumnMapping, "originalColumnMapping is null"), Objects.requireNonNull(nonNullColumnMappings, "nonNullColumnMappings is null"), new SchemaTableName(schema, table)), baseTablesOnOuterJoinSide, validRefreshColumns);
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public List<SchemaTableName> getBaseTables() {
        return this.baseTables;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public List<ColumnMapping> getColumnMappings() {
        return this.columnMappings;
    }

    @JsonProperty
    public List<SchemaTableName> getBaseTablesOnOuterJoinSide() {
        return this.baseTablesOnOuterJoinSide;
    }

    @JsonProperty
    public Optional<List<String>> getValidRefreshColumns() {
        return this.validRefreshColumns;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorMaterializedViewDefinition{");
        sb.append("originalSql=").append(this.originalSql);
        sb.append(",schema=").append(this.schema);
        sb.append(",table=").append(this.table);
        sb.append(",baseTables=").append(this.baseTables);
        sb.append(",owner=").append((String)this.owner.orElse(null));
        sb.append(",columnMappings=").append(this.columnMappings);
        sb.append(",baseTablesOnOuterJoinSide=").append(this.baseTablesOnOuterJoinSide);
        sb.append(",validRefreshColumns=").append((Object)this.validRefreshColumns.orElse(null));
        sb.append("}");
        return sb.toString();
    }

    @JsonIgnore
    public Map<String, Map<SchemaTableName, String>> getColumnMappingsAsMap() {
        return this.columnMappings.stream().collect(Collectors.toMap(mapping -> mapping.getViewColumn().getColumnName(), mapping -> mapping.getBaseTableColumns().stream().collect(Collectors.toMap(TableColumn::getTableName, TableColumn::getColumnName))));
    }

    @JsonIgnore
    public Map<String, Map<SchemaTableName, String>> getDirectColumnMappingsAsMap() {
        return this.columnMappings.stream().collect(Collectors.toMap(mapping -> mapping.getViewColumn().getColumnName(), mapping -> mapping.getBaseTableColumns().stream().filter(col -> col.isDirectMapped().orElse(true)).collect(Collectors.toMap(TableColumn::getTableName, TableColumn::getColumnName))));
    }

    @JsonIgnore
    private static List<ColumnMapping> convertFromMapToColumnMappings(Map<String, Map<SchemaTableName, String>> originalColumnMappings, Map<String, Map<SchemaTableName, String>> directColumnMappings, SchemaTableName sourceTable) {
        ArrayList<ColumnMapping> columnMappingList = new ArrayList<ColumnMapping>();
        for (String sourceColumn : originalColumnMappings.keySet()) {
            TableColumn viewColumn = new TableColumn(sourceTable, sourceColumn, true);
            Map<SchemaTableName, String> directMappings = directColumnMappings.get(sourceColumn);
            ArrayList<TableColumn> baseTableColumns = new ArrayList<TableColumn>();
            for (SchemaTableName baseTable : originalColumnMappings.get(sourceColumn).keySet()) {
                String column = originalColumnMappings.get(sourceColumn).get(baseTable);
                boolean isDirectMapped = directMappings != null && directMappings.containsKey(baseTable) && directMappings.get(baseTable) == column;
                baseTableColumns.add(new TableColumn(baseTable, column, isDirectMapped));
            }
            columnMappingList.add(new ColumnMapping(viewColumn, Collections.unmodifiableList(baseTableColumns)));
        }
        return Collections.unmodifiableList(columnMappingList);
    }

    public static final class TableColumn {
        private final SchemaTableName tableName;
        private final String columnName;
        private final Optional<Boolean> isDirectMapped;

        @JsonCreator
        public TableColumn(@JsonProperty(value="tableName") SchemaTableName tableName, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="isDirectMapped") Optional<Boolean> isDirectMapped) {
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
            this.columnName = Objects.requireNonNull(columnName, "columnName is null");
            this.isDirectMapped = Objects.requireNonNull(isDirectMapped, "isDirectMapped is null");
        }

        public TableColumn(SchemaTableName tableName, String columnName, boolean isDirectMapped) {
            this(tableName, columnName, Optional.of(isDirectMapped));
        }

        @JsonProperty
        public SchemaTableName getTableName() {
            return this.tableName;
        }

        @JsonProperty
        public String getColumnName() {
            return this.columnName;
        }

        @JsonProperty
        public Optional<Boolean> isDirectMapped() {
            return this.isDirectMapped;
        }

        public int hashCode() {
            return Objects.hash(this.tableName, this.columnName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableColumn that = (TableColumn)o;
            return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.isDirectMapped, that.isDirectMapped);
        }

        public String toString() {
            return this.tableName + ":" + this.columnName + (this.isDirectMapped.orElse(true) != false ? "" : "isDirectMapped:false");
        }
    }

    public static final class ColumnMapping {
        private final TableColumn viewColumn;
        private final List<TableColumn> baseTableColumns;

        @JsonCreator
        public ColumnMapping(@JsonProperty(value="viewColumn") TableColumn viewColumn, @JsonProperty(value="baseTableColumns") List<TableColumn> baseTableColumns) {
            this.viewColumn = Objects.requireNonNull(viewColumn, "viewColumn is null");
            this.baseTableColumns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(baseTableColumns, "baseTableColumns is null")));
        }

        @JsonProperty
        public TableColumn getViewColumn() {
            return this.viewColumn;
        }

        @JsonProperty
        public List<TableColumn> getBaseTableColumns() {
            return this.baseTableColumns;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ColumnMapping{");
            sb.append("viewColumn=").append(this.viewColumn);
            sb.append(",baseTableColumns=").append(this.baseTableColumns);
            sb.append("}");
            return sb.toString();
        }
    }
}

