/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.eventlistener;

import com.facebook.presto.spi.eventlistener.ResourceDistribution;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Objects;

public class StageStatistics {
    private final int stageId;
    private final int stageExecutionId;
    private final int tasks;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration retriedCpuTime;
    private final Duration totalBlockedTime;
    private final DataSize rawInputDataSize;
    private final DataSize processedInputDataSize;
    private final DataSize physicalWrittenDataSize;
    private final StageGcStatistics gcStatistics;
    private final ResourceDistribution cpuDistribution;
    private final ResourceDistribution memoryDistribution;

    public StageStatistics(int stageId, int stageExecutionId, int tasks, Duration totalScheduledTime, Duration totalCpuTime, Duration retriedCpuTime, Duration totalBlockedTime, DataSize rawInputDataSize, DataSize processedInputDataSize, DataSize physicalWrittenDataSize, StageGcStatistics gcStatistics, ResourceDistribution cpuDistribution, ResourceDistribution memoryDistribution) {
        this.stageId = stageId;
        this.stageExecutionId = stageExecutionId;
        this.tasks = tasks;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.retriedCpuTime = Objects.requireNonNull(retriedCpuTime, "retriedCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawDataInputSize is null");
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        this.physicalWrittenDataSize = Objects.requireNonNull(physicalWrittenDataSize, "physicalWrittenDataSize is null");
        this.gcStatistics = Objects.requireNonNull(gcStatistics, "gcStatistics is null");
        this.cpuDistribution = Objects.requireNonNull(cpuDistribution, "cpuDistribution is null");
        this.memoryDistribution = Objects.requireNonNull(memoryDistribution, "memoryDistribution is null");
    }

    public int getStageId() {
        return this.stageId;
    }

    public int getStageExecutionId() {
        return this.stageExecutionId;
    }

    public int getTasks() {
        return this.tasks;
    }

    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Duration getRetriedCpuTime() {
        return this.retriedCpuTime;
    }

    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    public DataSize getPhysicalWrittenDataSize() {
        return this.physicalWrittenDataSize;
    }

    public StageGcStatistics getGcStatistics() {
        return this.gcStatistics;
    }

    public ResourceDistribution getCpuDistribution() {
        return this.cpuDistribution;
    }

    public ResourceDistribution getMemoryDistribution() {
        return this.memoryDistribution;
    }
}

