/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, property="@type")
public abstract class PlanNode {
    private final Optional<SourceLocation> sourceLocation;
    private final PlanNodeId id;

    protected PlanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id) {
        this.sourceLocation = sourceLocation;
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    @JsonProperty(value="id")
    public PlanNodeId getId() {
        return this.id;
    }

    @JsonProperty(value="sourceLocation")
    public Optional<SourceLocation> getSourceLocation() {
        return this.sourceLocation;
    }

    public abstract List<PlanNode> getSources();

    public abstract List<VariableReferenceExpression> getOutputVariables();

    public abstract PlanNode replaceChildren(List<PlanNode> var1);

    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPlan(this, context);
    }
}

