/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CallExpression
extends RowExpression {
    private final String displayName;
    private final FunctionHandle functionHandle;
    private final Type returnType;
    private final List<RowExpression> arguments;

    public CallExpression(String displayName, FunctionHandle functionHandle, Type returnType, List<RowExpression> arguments) {
        this(arguments.stream().filter(x -> x.getSourceLocation().isPresent()).map(x -> x.getSourceLocation()).findFirst().orElse(Optional.empty()), displayName, functionHandle, returnType, arguments);
    }

    @JsonCreator
    public CallExpression(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="functionHandle") FunctionHandle functionHandle, @JsonProperty(value="returnType") Type returnType, @JsonProperty(value="arguments") List<RowExpression> arguments) {
        super(sourceLocation);
        this.displayName = Objects.requireNonNull(displayName, "displayName is null");
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.arguments = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(arguments, "arguments is null")));
    }

    @JsonProperty
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty
    public FunctionHandle getFunctionHandle() {
        return this.functionHandle;
    }

    @Override
    @JsonProperty(value="returnType")
    public Type getType() {
        return this.returnType;
    }

    @JsonProperty
    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString() {
        return this.displayName + "(" + String.join((CharSequence)", ", this.arguments.stream().map(RowExpression::toString).collect(Collectors.toList())) + ")";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.functionHandle, this.arguments);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CallExpression other = (CallExpression)obj;
        return Objects.equals(this.functionHandle, other.functionHandle) && Objects.equals(this.arguments, other.arguments);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCall(this, context);
    }
}

