/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SqlInvokedFunction
implements SqlFunction {
    private final List<Parameter> parameters;
    private final String description;
    private final RoutineCharacteristics routineCharacteristics;
    private final String body;
    private final Signature signature;
    private final SqlFunctionId functionId;
    private final FunctionVersion functionVersion;
    private final Optional<SqlFunctionHandle> functionHandle;
    private final Optional<AggregationFunctionMetadata> aggregationMetadata;

    @JsonCreator
    public SqlInvokedFunction(@JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="description") String description, @JsonProperty(value="routineCharacteristics") RoutineCharacteristics routineCharacteristics, @JsonProperty(value="body") String body, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="functionId") SqlFunctionId functionId) {
        this.parameters = parameters;
        this.description = description;
        this.routineCharacteristics = routineCharacteristics;
        this.body = body;
        this.signature = signature;
        this.functionId = functionId;
        this.functionVersion = FunctionVersion.notVersioned();
        this.functionHandle = Optional.empty();
        this.aggregationMetadata = Optional.empty();
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, FunctionVersion version) {
        this(functionName, parameters, Collections.emptyList(), returnType, description, routineCharacteristics, body, version, FunctionKind.SCALAR, Optional.empty());
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, FunctionVersion version, FunctionKind kind, Optional<AggregationFunctionMetadata> aggregationMetadata) {
        this(functionName, parameters, Collections.emptyList(), returnType, description, routineCharacteristics, body, version, kind, aggregationMetadata);
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, List<TypeVariableConstraint> typeVariableConstraints, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, FunctionVersion version, FunctionKind kind, Optional<AggregationFunctionMetadata> aggregationMetadata) {
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.routineCharacteristics = Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null");
        this.body = Objects.requireNonNull(body, "body is null");
        List argumentTypes = parameters.stream().map(Parameter::getType).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        this.signature = new Signature(functionName, kind, typeVariableConstraints, Collections.emptyList(), returnType, argumentTypes, false);
        this.functionId = new SqlFunctionId(functionName, argumentTypes);
        this.functionVersion = Objects.requireNonNull(version, "version is null");
        this.functionHandle = version.hasVersion() ? Optional.of(new SqlFunctionHandle(this.functionId, version.toString())) : Optional.empty();
        this.aggregationMetadata = Objects.requireNonNull(aggregationMetadata, "aggregationMetadata is null");
        if (kind == FunctionKind.AGGREGATE && !aggregationMetadata.isPresent() || kind != FunctionKind.AGGREGATE && aggregationMetadata.isPresent()) {
            throw new IllegalArgumentException("aggregationMetadata must be present for aggregation functions and absent otherwise");
        }
    }

    public SqlInvokedFunction withVersion(String version) {
        if (this.hasVersion()) {
            throw new IllegalArgumentException(String.format("function %s is already with version %s", this.signature.getName(), this.getVersion()));
        }
        return new SqlInvokedFunction(this.signature.getName(), this.parameters, this.signature.getReturnType(), this.description, this.routineCharacteristics, this.body, FunctionVersion.withVersion(version), this.signature.getKind(), this.aggregationMetadata);
    }

    @Override
    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    @Override
    public boolean isDeterministic() {
        return this.routineCharacteristics.isDeterministic();
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.routineCharacteristics.isCalledOnNullInput();
    }

    @Override
    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public RoutineCharacteristics getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }

    @JsonProperty
    public String getBody() {
        return this.body;
    }

    @JsonProperty
    public SqlFunctionId getFunctionId() {
        return this.functionId;
    }

    public Optional<SqlFunctionHandle> getFunctionHandle() {
        return this.functionHandle;
    }

    public boolean hasVersion() {
        return this.functionVersion.hasVersion();
    }

    public FunctionVersion getVersion() {
        return this.functionVersion;
    }

    public Optional<AggregationFunctionMetadata> getAggregationMetadata() {
        return this.aggregationMetadata;
    }

    public SqlFunctionHandle getRequiredFunctionHandle() {
        Optional<SqlFunctionHandle> functionHandle = this.getFunctionHandle();
        if (!functionHandle.isPresent()) {
            throw new IllegalStateException("missing functionHandle");
        }
        return functionHandle.get();
    }

    public String getRequiredVersion() {
        if (!this.hasVersion()) {
            throw new IllegalStateException("missing version");
        }
        return this.getVersion().toString();
    }

    public boolean hasSameDefinitionAs(SqlInvokedFunction function) {
        Objects.requireNonNull(function, "function is null");
        return Objects.equals(this.parameters, function.parameters) && Objects.equals(this.description, function.description) && Objects.equals(this.routineCharacteristics, function.routineCharacteristics) && Objects.equals(this.body, function.body) && Objects.equals(this.signature, function.signature) && Objects.equals(this.aggregationMetadata, function.aggregationMetadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlInvokedFunction o = (SqlInvokedFunction)obj;
        return Objects.equals(this.parameters, o.parameters) && Objects.equals(this.description, o.description) && Objects.equals(this.routineCharacteristics, o.routineCharacteristics) && Objects.equals(this.body, o.body) && Objects.equals(this.signature, o.signature) && Objects.equals(this.functionId, o.functionId) && Objects.equals(this.functionHandle, o.functionHandle) && Objects.equals(this.aggregationMetadata, o.aggregationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.description, this.routineCharacteristics, this.body, this.signature, this.functionId, this.functionHandle);
    }

    public String toString() {
        return String.format("%s(%s):%s%s [%s%s] {%s} %s", new Object[]{this.signature.getName(), this.parameters.stream().map(Object::toString).collect(Collectors.joining(",")), this.signature.getReturnType(), this.hasVersion() ? ":" + this.getVersion() : "", this.signature.getKind(), this.signature.getKind() == FunctionKind.AGGREGATE ? ", " + this.getAggregationMetadata().get() : "", this.body, this.routineCharacteristics});
    }
}

