/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.TimeZoneKey;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.security.ConnectorIdentity;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class TestingSession {
    public static final ConnectorSession SESSION = new ConnectorSession(){

        public String getQueryId() {
            return "test_query_id";
        }

        public Optional<String> getSource() {
            return Optional.of("TestSource");
        }

        public ConnectorIdentity getIdentity() {
            return new ConnectorIdentity("user", Optional.empty(), Optional.empty());
        }

        public TimeZoneKey getTimeZoneKey() {
            return TimeZoneKey.UTC_KEY;
        }

        public Optional<String> getClientInfo() {
            return Optional.of("TestClientInfo");
        }

        public Set<String> getClientTags() {
            return ImmutableSet.of();
        }

        public Locale getLocale() {
            return Locale.ENGLISH;
        }

        public long getStartTime() {
            return 0L;
        }

        public Optional<String> getTraceToken() {
            return Optional.empty();
        }

        public SqlFunctionProperties getSqlFunctionProperties() {
            return SqlFunctionProperties.builder().setTimeZoneKey(TimeZoneKey.UTC_KEY).setLegacyTimestamp(true).setSessionStartTime(this.getStartTime()).setSessionLocale(this.getLocale()).setSessionUser(this.getUser()).build();
        }

        public Map<SqlFunctionId, SqlInvokedFunction> getSessionFunctions() {
            return ImmutableMap.of();
        }

        public <T> T getProperty(String name, Class<T> type) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Unknown session property " + name);
        }

        public Optional<String> getSchema() {
            return Optional.empty();
        }

        public WarningCollector getWarningCollector() {
            return WarningCollector.NOOP;
        }
    };

    private TestingSession() {
    }
}

