/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.testing;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Set;
import org.testng.Assert;

public final class InterfaceTestUtils {
    private InterfaceTestUtils() {
    }

    public static <I, C extends I> void assertAllMethodsOverridden(Class<I> iface, Class<C> clazz) {
        Assert.assertEquals((Set)ImmutableSet.copyOf((Object[])clazz.getInterfaces()), (Set)ImmutableSet.of(iface));
        for (Method method : iface.getMethods()) {
            try {
                Method override = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                Assert.assertEquals(override.getReturnType(), method.getReturnType());
            }
            catch (NoSuchMethodException e) {
                Assert.fail((String)String.format("%s does not override [%s]", clazz.getName(), method));
            }
        }
    }
}

