/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.constraints.TableConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final Optional<String> comment;
    private final List<ColumnMetadata> columns;
    private final Map<String, Object> properties;
    private final List<TableConstraint<ColumnHandle>> tableConstraints;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        this(table, columns, Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties) {
        this(table, columns, properties, Optional.empty(), Collections.emptyList());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment) {
        this(table, columns, properties, comment, Collections.emptyList());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment, List<TableConstraint<ColumnHandle>> tableConstraints) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(comment, "comment is null");
        Objects.requireNonNull(tableConstraints, "tableConstraints is null");
        this.table = table;
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnMetadata>(columns));
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.comment = comment;
        this.tableConstraints = Collections.unmodifiableList(new ArrayList<TableConstraint<ColumnHandle>>(tableConstraints));
    }

    public static <T, R> List<TableConstraint<R>> rebaseTableConstraints(List<TableConstraint<T>> tableConstraints, Map<T, R> assignments) {
        ArrayList mappedTableConstraints = new ArrayList();
        tableConstraints.stream().forEach(tableConstraint -> {
            Optional mappedConstraint = tableConstraint.rebaseConstraint(assignments);
            if (mappedConstraint.isPresent()) {
                mappedTableConstraints.add(mappedConstraint.get());
            }
        });
        return mappedTableConstraints;
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public List<TableConstraint<ColumnHandle>> getTableConstraints() {
        return this.tableConstraints;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append(", tableConstraints=").append(this.tableConstraints);
        sb.append(", properties=").append(this.properties);
        this.comment.ifPresent(value -> sb.append(", comment='").append((String)value).append("'"));
        sb.append('}');
        return sb.toString();
    }
}

