/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.FunctionType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LambdaDefinitionExpression
extends RowExpression {
    private final List<Type> argumentTypes;
    private final List<String> arguments;
    private final RowExpression body;
    private final String canonicalizedBody;

    @JsonCreator
    public LambdaDefinitionExpression(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="argumentTypes") List<Type> argumentTypes, @JsonProperty(value="arguments") List<String> arguments, @JsonProperty(value="body") RowExpression body) {
        super(sourceLocation);
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
        this.arguments = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(arguments, "arguments is null")));
        LambdaDefinitionExpression.checkArgument(argumentTypes.size() == arguments.size(), "Number of argument types does not match number of arguments", new Object[0]);
        this.body = Objects.requireNonNull(body, "body is null");
        this.canonicalizedBody = body.accept(new CanonicalizeExpression(arguments, argumentTypes), null);
    }

    @JsonProperty
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public RowExpression getBody() {
        return this.body;
    }

    @Override
    public Type getType() {
        return new FunctionType(this.argumentTypes, this.body.getType());
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.singletonList(this.body);
    }

    @Override
    public String toString() {
        return "(" + String.join((CharSequence)",", this.arguments) + ") -> " + this.body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaDefinitionExpression that = (LambdaDefinitionExpression)o;
        return Objects.equals(this.argumentTypes, that.argumentTypes) && Objects.equals(this.canonicalizedBody, that.canonicalizedBody);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argumentTypes, this.canonicalizedBody);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitLambda(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this.getSourceLocation().isPresent() ? new LambdaDefinitionExpression(Optional.empty(), this.argumentTypes, this.arguments, this.body) : this;
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }

    private static class CanonicalizeExpression
    implements RowExpressionVisitor<String, Void> {
        private final Map<String, String> canonicalizedArguments = new HashMap<String, String>();

        public CanonicalizeExpression(List<String> arguments, List<Type> argumentTypes) {
            for (int i = 0; i < arguments.size(); ++i) {
                this.canonicalizedArguments.put(arguments.get(i), String.format("%s_%d", argumentTypes.get(i).toString(), i));
            }
        }

        @Override
        public String visitCall(CallExpression call, Void context) {
            return String.format("%s.%s(%s):%s", call.getFunctionHandle().getCatalogSchemaName(), call.getDisplayName(), String.join((CharSequence)", ", call.getArguments().stream().map(e -> e.accept(this, null)).collect(Collectors.toList())), call.getType());
        }

        @Override
        public String visitInputReference(InputReferenceExpression reference, Void context) {
            return reference.toString();
        }

        @Override
        public String visitConstant(ConstantExpression literal, Void context) {
            if (literal.getValue() instanceof Slice) {
                Slice slice = (Slice)literal.getValue();
                if (slice.hasByteArray()) {
                    return Slices.wrappedBuffer((ByteBuffer)Base64.getEncoder().encode(slice.toByteBuffer())).toStringUtf8();
                }
                return Slices.wrappedBuffer((byte[])Base64.getEncoder().encode(slice.getBytes())).toStringUtf8();
            }
            if (literal.getValue() instanceof Block) {
                return String.format("%d", literal.hashCode());
            }
            return literal.toString();
        }

        @Override
        public String visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return String.format("(%s) -> %s", String.join((CharSequence)", ", lambda.argumentTypes.stream().map(Object::toString).collect(Collectors.toList())), lambda.body.accept(this, null));
        }

        @Override
        public String visitVariableReference(VariableReferenceExpression reference, Void context) {
            if (this.canonicalizedArguments.containsKey(reference.getName())) {
                return this.canonicalizedArguments.get(reference.getName());
            }
            return reference.getName();
        }

        @Override
        public String visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            return String.format("%s(%s)", new Object[]{specialForm.getForm(), String.join((CharSequence)", ", specialForm.getArguments().stream().map(e -> e.accept(this, null)).collect(Collectors.toList()))});
        }
    }
}

