/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.NotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import java.util.Objects;

public class MaterializedViewNotFoundException
extends NotFoundException {
    private final SchemaTableName viewName;

    public MaterializedViewNotFoundException(SchemaTableName viewName) {
        this(viewName, String.format("Materialized view '%s' not found", viewName));
    }

    public MaterializedViewNotFoundException(SchemaTableName viewName, String message) {
        super(message);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public MaterializedViewNotFoundException(SchemaTableName viewName, Throwable cause) {
        this(viewName, String.format("Materialized view '%s' not found", viewName), cause);
    }

    public MaterializedViewNotFoundException(SchemaTableName viewName, String message, Throwable cause) {
        super(message, cause);
        this.viewName = Objects.requireNonNull(viewName, "viewName is null");
    }

    public SchemaTableName getViewName() {
        return this.viewName;
    }
}

