/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.connector;

import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ConnectorBucketNodeMap {
    private final int bucketCount;
    private final Optional<List<Node>> bucketToNode;
    private final NodeSelectionStrategy nodeSelectionStrategy;

    public static ConnectorBucketNodeMap createBucketNodeMap(int bucketCount) {
        return new ConnectorBucketNodeMap(bucketCount, Optional.empty(), NodeSelectionStrategy.NO_PREFERENCE);
    }

    public static ConnectorBucketNodeMap createBucketNodeMap(List<Node> bucketToNode, NodeSelectionStrategy nodeSelectionStrategy) {
        return new ConnectorBucketNodeMap(bucketToNode.size(), Optional.of(bucketToNode), nodeSelectionStrategy);
    }

    private ConnectorBucketNodeMap(int bucketCount, Optional<List<Node>> bucketToNode, NodeSelectionStrategy nodeSelectionStrategy) {
        this.nodeSelectionStrategy = Objects.requireNonNull(nodeSelectionStrategy, "nodeSelectionStrategy is null");
        if (bucketCount <= 0) {
            throw new IllegalArgumentException("bucketCount must be positive");
        }
        if (bucketToNode.isPresent() && bucketToNode.get().size() != bucketCount) {
            throw new IllegalArgumentException(String.format("Mismatched bucket count in bucketToNode (%s) and bucketCount (%s)", bucketToNode.get().size(), bucketCount));
        }
        this.bucketCount = bucketCount;
        this.bucketToNode = bucketToNode.map(ArrayList::new).map(Collections::unmodifiableList);
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    public List<Node> getFixedMapping() {
        return this.bucketToNode.orElseThrow(() -> new IllegalArgumentException("No fixed bucket to node mapping"));
    }
}

