/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class InputReferenceExpression
extends RowExpression {
    private final int field;
    private final Type type;

    @JsonCreator
    public InputReferenceExpression(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="field") int field, @JsonProperty(value="type") Type type) {
        super(sourceLocation);
        Objects.requireNonNull(type, "type is null");
        this.field = field;
        this.type = type;
    }

    @JsonProperty
    public int getField() {
        return this.field;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.type);
    }

    @Override
    public String toString() {
        return "#" + this.field;
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInputReference(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this.getSourceLocation().isPresent() ? new InputReferenceExpression(Optional.empty(), this.field, this.type) : this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InputReferenceExpression other = (InputReferenceExpression)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.type, other.type);
    }
}

