/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import java.util.Objects;
import java.util.Optional;

public class AuthorizedIdentity {
    private final String userName;
    private final Optional<String> reasonForSelect;
    private final Optional<Boolean> delegationCheckResult;

    public AuthorizedIdentity(String userName, String reasonForSelect, Boolean delegationCheckResult) {
        this.userName = Objects.requireNonNull(userName, "userName is null");
        this.reasonForSelect = Optional.ofNullable(reasonForSelect);
        this.delegationCheckResult = Optional.ofNullable(delegationCheckResult);
    }

    public String getUserName() {
        return this.userName;
    }

    public Optional<String> getReasonForSelect() {
        return this.reasonForSelect;
    }

    public Optional<Boolean> getDelegationCheckResult() {
        return this.delegationCheckResult;
    }
}

