/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SequenceNode
extends PlanNode {
    private final List<PlanNode> cteProducers;
    private final PlanNode primarySource;

    @JsonCreator
    public SequenceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId planNodeId, @JsonProperty(value="cteProducers") List<PlanNode> left, @JsonProperty(value="primarySource") PlanNode primarySource) {
        this(sourceLocation, planNodeId, Optional.empty(), left, primarySource);
    }

    public SequenceNode(Optional<SourceLocation> sourceLocation, PlanNodeId planNodeId, Optional<PlanNode> statsEquivalentPlanNode, List<PlanNode> leftList, PlanNode primarySource) {
        super(sourceLocation, planNodeId, statsEquivalentPlanNode);
        this.cteProducers = leftList;
        this.primarySource = primarySource;
    }

    @JsonProperty
    public List<PlanNode> getCteProducers() {
        return this.cteProducers;
    }

    @JsonProperty
    public PlanNode getPrimarySource() {
        return this.primarySource;
    }

    @Override
    public List<PlanNode> getSources() {
        ArrayList<PlanNode> children = new ArrayList<PlanNode>(this.cteProducers);
        children.add(this.primarySource);
        return children;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.primarySource.getOutputVariables();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new SequenceNode(newChildren.get(0).getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.subList(0, newChildren.size() - 1), newChildren.get(newChildren.size() - 1));
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new SequenceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.cteProducers, this.getPrimarySource());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSequence(this, context);
    }
}

