/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class SetOperationNode
extends PlanNode {
    private final List<PlanNode> sources;
    private final Map<VariableReferenceExpression, List<VariableReferenceExpression>> outputToInputs;
    private final List<VariableReferenceExpression> outputVariables;

    @JsonCreator
    protected SetOperationNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="sources") List<PlanNode> sources, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="outputToInputs") Map<VariableReferenceExpression, List<VariableReferenceExpression>> outputToInputs) {
        this(sourceLocation, id, Optional.empty(), sources, outputVariables, outputToInputs);
    }

    protected SetOperationNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, List<PlanNode> sources, List<VariableReferenceExpression> outputVariables, Map<VariableReferenceExpression, List<VariableReferenceExpression>> outputToInputs) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(sources, "sources is null");
        SetOperationNode.checkArgument(!sources.isEmpty(), "Must have at least one source");
        Objects.requireNonNull(outputToInputs, "outputToInputs is null");
        this.sources = Collections.unmodifiableList(new ArrayList<PlanNode>(sources));
        LinkedHashMap copiedMap = new LinkedHashMap();
        outputToInputs.forEach((key, value) -> copiedMap.put(key, Collections.unmodifiableList(new ArrayList(value))));
        this.outputToInputs = Collections.unmodifiableMap(copiedMap);
        this.outputVariables = Collections.unmodifiableList(new ArrayList<VariableReferenceExpression>(outputVariables));
        for (Collection collection : this.outputToInputs.values()) {
            SetOperationNode.checkArgument(collection.size() == this.sources.size(), String.format("Every source needs to map its variables to an output %s operation variables", this.getClass().getSimpleName()));
        }
        for (int i = 0; i < sources.size(); ++i) {
            for (List<VariableReferenceExpression> expectedInputs : this.outputToInputs.values()) {
                SetOperationNode.checkArgument(sources.get(i).getOutputVariables().contains(expectedInputs.get(i)), "Source does not provide required variables");
            }
        }
    }

    @Override
    @JsonProperty
    public List<PlanNode> getSources() {
        return this.sources;
    }

    @JsonProperty
    public Map<VariableReferenceExpression, List<VariableReferenceExpression>> getVariableMapping() {
        return this.outputToInputs;
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    public List<VariableReferenceExpression> sourceOutputLayout(int sourceIndex) {
        return Collections.unmodifiableList(this.getOutputVariables().stream().map(variable -> this.outputToInputs.get(variable).get(sourceIndex)).collect(Collectors.toList()));
    }

    public Map<VariableReferenceExpression, VariableReferenceExpression> sourceVariableMap(int sourceIndex) {
        LinkedHashMap<VariableReferenceExpression, VariableReferenceExpression> result = new LinkedHashMap<VariableReferenceExpression, VariableReferenceExpression>();
        for (Map.Entry<VariableReferenceExpression, List<VariableReferenceExpression>> entry : this.outputToInputs.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get(sourceIndex));
        }
        return Collections.unmodifiableMap(result);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

