/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.transaction;

import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

@ThriftEnum
public enum IsolationLevel {
    SERIALIZABLE(0),
    REPEATABLE_READ(1),
    READ_COMMITTED(2),
    READ_UNCOMMITTED(3);

    private final int value;

    public boolean meetsRequirementOf(IsolationLevel requirement) {
        switch (this) {
            case READ_UNCOMMITTED: {
                return requirement == READ_UNCOMMITTED;
            }
            case READ_COMMITTED: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED;
            }
            case REPEATABLE_READ: {
                return requirement == READ_UNCOMMITTED || requirement == READ_COMMITTED || requirement == REPEATABLE_READ;
            }
            case SERIALIZABLE: {
                return true;
            }
        }
        throw new AssertionError((Object)("Unhandled isolation level: " + (Object)((Object)this)));
    }

    private IsolationLevel(int value) {
        this.value = value;
    }

    @ThriftEnumValue
    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }

    public static void checkConnectorSupports(IsolationLevel supportedLevel, IsolationLevel requestedLevel) {
        if (!supportedLevel.meetsRequirementOf(requestedLevel)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.UNSUPPORTED_ISOLATION_LEVEL, String.format("Connector supported isolation level %s does not meet requested isolation level %s", new Object[]{supportedLevel, requestedLevel}));
        }
    }
}

