/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import java.util.List;
import java.util.Objects;

public class TableMetadata {
    private final ConnectorId connectorId;
    private final ConnectorTableMetadata metadata;

    public TableMetadata(ConnectorId connectorId, ConnectorTableMetadata metadata) {
        Objects.requireNonNull(connectorId, "catalog is null");
        Objects.requireNonNull(metadata, "metadata is null");
        this.connectorId = connectorId;
        this.metadata = metadata;
    }

    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    public ConnectorTableMetadata getMetadata() {
        return this.metadata;
    }

    public SchemaTableName getTable() {
        return this.metadata.getTable();
    }

    public List<ColumnMetadata> getColumns() {
        return this.metadata.getColumns();
    }

    public ColumnMetadata getColumn(String name) {
        return this.getColumns().stream().filter(columnMetadata -> columnMetadata.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid column name: %s", name)));
    }
}

