/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class QuantifiedComparisonExpression
extends IntermediateFormExpression {
    private final OperatorType operator;
    private final Quantifier quantifier;
    private final RowExpression value;
    private final RowExpression subquery;

    public QuantifiedComparisonExpression(Optional<SourceLocation> sourceLocation, OperatorType operator, Quantifier quantifier, RowExpression value, RowExpression subquery) {
        super(sourceLocation);
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.quantifier = Objects.requireNonNull(quantifier, "quantifier is null");
        this.value = Objects.requireNonNull(value, "value is null");
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public RowExpression getValue() {
        return this.value;
    }

    public RowExpression getSubquery() {
        return this.subquery;
    }

    @Override
    public Type getType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this.value, this.subquery));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantifiedComparisonExpression that = (QuantifiedComparisonExpression)o;
        return this.operator == that.operator && this.quantifier == that.quantifier && Objects.equals(this.value, that.value) && Objects.equals(this.subquery, that.subquery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.quantifier, this.value, this.subquery});
    }

    @Override
    public String toString() {
        return String.format("%s %s %s (%s)", new Object[]{this.value, this.operator, this.quantifier, this.subquery});
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitQuantifiedComparisonExpression(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this;
    }

    public static enum Quantifier {
        ALL,
        ANY,
        SOME;

    }
}

