/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VariableReferenceExpression
extends RowExpression
implements Comparable<VariableReferenceExpression> {
    private final String name;
    private final Type type;

    @JsonCreator
    public VariableReferenceExpression(@JsonProperty(value="sourceLocation") Optional<SourceLocation> sourceLocation, @JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
        super(sourceLocation);
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitVariableReference(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this.getSourceLocation().isPresent() ? new VariableReferenceExpression(Optional.empty(), this.name, this.type) : this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VariableReferenceExpression other = (VariableReferenceExpression)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    @Override
    public int compareTo(VariableReferenceExpression o) {
        int nameComparison = this.name.compareTo(o.name);
        if (nameComparison != 0) {
            return nameComparison;
        }
        return this.type.getTypeSignature().toString().compareTo(o.type.getTypeSignature().toString());
    }
}

