/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PartialAggregationStatistics;
import com.facebook.presto.spi.statistics.TableWriterNodeStatistics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@ThriftStruct
public class PlanStatistics {
    private static final PlanStatistics EMPTY = new PlanStatistics(Estimate.unknown(), Estimate.unknown(), 0.0, JoinNodeStatistics.empty(), TableWriterNodeStatistics.empty(), PartialAggregationStatistics.empty());
    private final Estimate rowCount;
    private final Estimate outputSize;
    private final double confidence;
    private final JoinNodeStatistics joinNodeStatistics;
    private final TableWriterNodeStatistics tableWriterNodeStatistics;
    private final PartialAggregationStatistics partialAggregationStatistics;

    public static PlanStatistics empty() {
        return EMPTY;
    }

    @JsonCreator
    @ThriftConstructor
    public PlanStatistics(@JsonProperty(value="rowCount") Estimate rowCount, @JsonProperty(value="outputSize") Estimate outputSize, @JsonProperty(value="confidence") double confidence, @JsonProperty(value="joinNodeStatistics") JoinNodeStatistics joinNodeStatistics, @JsonProperty(value="tableWriterNodeStatistics") TableWriterNodeStatistics tableWriterNodeStatistics, @JsonProperty(value="partialAggregationStatistics") PartialAggregationStatistics partialAggregationStatistics) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount is null");
        this.outputSize = Objects.requireNonNull(outputSize, "outputSize is null");
        PlanStatistics.checkArgument(confidence >= 0.0 && confidence <= 1.0, "confidence should be between 0 and 1");
        this.confidence = confidence;
        this.joinNodeStatistics = Objects.requireNonNull(joinNodeStatistics == null ? JoinNodeStatistics.empty() : joinNodeStatistics, "joinNodeStatistics is null");
        this.tableWriterNodeStatistics = Objects.requireNonNull(tableWriterNodeStatistics == null ? TableWriterNodeStatistics.empty() : tableWriterNodeStatistics, "tableWriterNodeStatistics is null");
        this.partialAggregationStatistics = Objects.requireNonNull(partialAggregationStatistics == null ? PartialAggregationStatistics.empty() : partialAggregationStatistics, "partialAggregationStatistics is null");
    }

    @JsonProperty
    @ThriftField(value=1)
    public Estimate getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    @ThriftField(value=2)
    public Estimate getOutputSize() {
        return this.outputSize;
    }

    @JsonProperty
    @ThriftField(value=3)
    public double getConfidence() {
        return this.confidence;
    }

    @JsonProperty
    @ThriftField(value=6, requiredness=ThriftField.Requiredness.OPTIONAL)
    public JoinNodeStatistics getJoinNodeStatistics() {
        return this.joinNodeStatistics;
    }

    @JsonProperty
    @ThriftField(value=7, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TableWriterNodeStatistics getTableWriterNodeStatistics() {
        return this.tableWriterNodeStatistics;
    }

    @JsonProperty
    @ThriftField(value=8, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PartialAggregationStatistics getPartialAggregationStatistics() {
        return this.partialAggregationStatistics;
    }

    public PlanStatistics update(PlanStatistics planStatistics) {
        return new PlanStatistics(planStatistics.getRowCount(), planStatistics.getOutputSize(), planStatistics.getConfidence(), planStatistics.getJoinNodeStatistics().isEmpty() ? this.getJoinNodeStatistics() : planStatistics.getJoinNodeStatistics(), planStatistics.getTableWriterNodeStatistics().isEmpty() ? this.getTableWriterNodeStatistics() : planStatistics.getTableWriterNodeStatistics(), planStatistics.getPartialAggregationStatistics().isEmpty() ? this.getPartialAggregationStatistics() : planStatistics.getPartialAggregationStatistics());
    }

    public PlanStatistics updateAggregationStatistics(PartialAggregationStatistics partialAggregationStatistics) {
        return new PlanStatistics(this.getRowCount(), this.getOutputSize(), this.getConfidence(), this.getJoinNodeStatistics(), this.getTableWriterNodeStatistics(), partialAggregationStatistics);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanStatistics that = (PlanStatistics)o;
        return Double.compare(that.confidence, this.confidence) == 0 && Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.outputSize, that.outputSize) && Objects.equals(this.joinNodeStatistics, that.joinNodeStatistics) && Objects.equals(this.tableWriterNodeStatistics, that.tableWriterNodeStatistics) && Objects.equals(this.partialAggregationStatistics, that.partialAggregationStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.outputSize, this.confidence, this.joinNodeStatistics, this.tableWriterNodeStatistics, this.partialAggregationStatistics);
    }

    public String toString() {
        return "PlanStatistics{rowCount=" + this.rowCount + ", outputSize=" + this.outputSize + ", confidence=" + this.confidence + ", joinNodeStatistics=" + this.joinNodeStatistics + ", tableWriterNodeStatistics=" + this.tableWriterNodeStatistics + ", partialAggregationStatistics=" + this.partialAggregationStatistics + '}';
    }
}

