/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public final class QueryId {
    private final String id;

    @JsonCreator
    public static QueryId valueOf(String queryId) {
        return new QueryId(queryId);
    }

    @ThriftConstructor
    public QueryId(String id) {
        this.id = QueryId.validateId(id);
    }

    @ThriftField(value=1)
    public String getId() {
        return this.id;
    }

    @JsonValue
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryId other = (QueryId)obj;
        return Objects.equals(this.id, other.id);
    }

    private static boolean isIdMatchPattern(String id) {
        if (id.length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static String validateId(String id) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(!id.isEmpty(), "id is empty", new Object[0]);
        QueryId.checkArgument(QueryId.isIdMatchPattern(id), "Invalid id %s", id);
        return id;
    }

    public static List<String> parseDottedId(String id, int expectedParts, String name) {
        Objects.requireNonNull(id, "id is null");
        QueryId.checkArgument(expectedParts > 0, "expectedParts must be at least 1", new Object[0]);
        Objects.requireNonNull(name, "name is null");
        List<String> ids = Collections.unmodifiableList(Arrays.asList(id.split("\\.")));
        QueryId.checkArgument(ids.size() == expectedParts, "Invalid %s %s", name, id);
        for (String part : ids) {
            QueryId.checkArgument(!part.isEmpty(), "Invalid id %s", id);
            QueryId.checkArgument(QueryId.isIdMatchPattern(part), "Invalid id %s", id);
        }
        return ids;
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

