/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaUtil;
import java.util.Objects;

public class SchemaTablePrefix {
    private final String schemaName;
    private final String tableName;

    public SchemaTablePrefix() {
        this.schemaName = null;
        this.tableName = null;
    }

    public SchemaTablePrefix(String schemaName) {
        this.schemaName = SchemaUtil.checkNotEmpty(schemaName, "schemaName");
        this.tableName = null;
    }

    public SchemaTablePrefix(String schemaName, String tableName) {
        this.schemaName = SchemaUtil.checkNotEmpty(schemaName, "schemaName");
        this.tableName = SchemaUtil.checkNotEmpty(tableName, "tableName");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean matches(SchemaTableName schemaTableName) {
        if (this.schemaName == null) {
            return true;
        }
        if (!this.schemaName.equals(schemaTableName.getSchemaName())) {
            return false;
        }
        return this.tableName == null || this.tableName.equals(schemaTableName.getTableName());
    }

    public SchemaTableName toSchemaTableName() {
        if (this.schemaName == null || this.tableName == null) {
            throw new IllegalStateException("both schemaName and tableName must be set");
        }
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaTablePrefix other = (SchemaTablePrefix)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return (this.schemaName == null ? "*" : this.schemaName) + '.' + (this.tableName == null ? "*" : this.tableName);
    }
}

