/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.Utils;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.LambdaArgumentDescriptor;
import com.facebook.presto.spi.function.LambdaDescriptor;
import com.facebook.presto.spi.function.Signature;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ComplexTypeFunctionDescriptor {
    public static final List<String> MAP_AND_ARRAY = Collections.unmodifiableList(Arrays.asList("map", "array"));
    public static final ComplexTypeFunctionDescriptor DEFAULT = new ComplexTypeFunctionDescriptor(true, Collections.emptyList(), Optional.of(Collections.emptySet()), Optional.of(ComplexTypeFunctionDescriptor::allSubfieldsRequired));
    private final boolean isAccessingInputValues;
    private final Optional<Set<Integer>> argumentIndicesContainingMapOrArray;
    private final Optional<Function<Set<Subfield>, Set<Subfield>>> outputToInputTransformationFunction;
    private final List<LambdaDescriptor> lambdaDescriptors;

    public ComplexTypeFunctionDescriptor(boolean isAccessingInputValues, List<LambdaDescriptor> lambdaDescriptors, Optional<Set<Integer>> argumentIndicesContainingMapOrArray, Optional<Function<Set<Subfield>, Set<Subfield>>> outputToInputTransformationFunction, Signature signature) {
        this(isAccessingInputValues, lambdaDescriptors, argumentIndicesContainingMapOrArray, outputToInputTransformationFunction, signature.getArgumentTypes());
    }

    public ComplexTypeFunctionDescriptor(boolean isAccessingInputValues, List<LambdaDescriptor> lambdaDescriptors, Optional<Set<Integer>> argumentIndicesContainingMapOrArray, Optional<Function<Set<Subfield>, Set<Subfield>>> outputToInputTransformationFunction, List<TypeSignature> argumentTypes) {
        this(isAccessingInputValues, lambdaDescriptors, argumentIndicesContainingMapOrArray, outputToInputTransformationFunction);
        if (argumentIndicesContainingMapOrArray.isPresent()) {
            Utils.checkArgument((boolean)argumentIndicesContainingMapOrArray.get().stream().allMatch(index -> index >= 0 && index < argumentTypes.size() && MAP_AND_ARRAY.contains(((TypeSignature)argumentTypes.get((int)index)).getBase().toLowerCase(Locale.ENGLISH))));
        }
        for (LambdaDescriptor lambdaDescriptor : lambdaDescriptors) {
            Utils.checkArgument((lambdaDescriptor.getCallArgumentIndex() >= 0 && argumentTypes.get(lambdaDescriptor.getCallArgumentIndex()).isFunction() ? 1 : 0) != 0);
            Utils.checkArgument((boolean)lambdaDescriptor.getLambdaArgumentDescriptors().keySet().stream().allMatch(argumentIndex -> argumentIndex >= 0 && argumentIndex < argumentTypes.size()));
            for (Integer lambdaArgumentIndex : lambdaDescriptor.getLambdaArgumentDescriptors().keySet()) {
                Utils.checkArgument((lambdaArgumentIndex >= 0 && lambdaArgumentIndex < argumentTypes.get(lambdaDescriptor.getCallArgumentIndex()).getParameters().size() - 1 ? 1 : 0) != 0);
                LambdaArgumentDescriptor lambdaArgumentDescriptor = lambdaDescriptor.getLambdaArgumentDescriptors().get(lambdaArgumentIndex);
                Utils.checkArgument((lambdaArgumentDescriptor.getCallArgumentIndex() >= 0 && lambdaArgumentDescriptor.getCallArgumentIndex() < argumentTypes.size() ? 1 : 0) != 0);
            }
        }
    }

    public ComplexTypeFunctionDescriptor(boolean isAccessingInputValues, List<LambdaDescriptor> lambdaDescriptors, Optional<Set<Integer>> argumentIndicesContainingMapOrArray, Optional<Function<Set<Subfield>, Set<Subfield>>> outputToInputTransformationFunction) {
        Objects.requireNonNull(argumentIndicesContainingMapOrArray, "argumentIndicesContainingMapOrArray is null");
        this.isAccessingInputValues = isAccessingInputValues;
        this.lambdaDescriptors = Collections.unmodifiableList(Objects.requireNonNull(lambdaDescriptors, "lambdaDescriptors is null"));
        this.argumentIndicesContainingMapOrArray = argumentIndicesContainingMapOrArray.isPresent() ? Optional.of(Collections.unmodifiableSet(argumentIndicesContainingMapOrArray.get())) : Optional.empty();
        this.outputToInputTransformationFunction = Objects.requireNonNull(outputToInputTransformationFunction, "outputToInputTransformationFunction is null");
    }

    public static ComplexTypeFunctionDescriptor defaultFunctionDescriptor() {
        return DEFAULT;
    }

    public boolean isAccessingInputValues() {
        return this.isAccessingInputValues;
    }

    public Optional<Set<Integer>> getArgumentIndicesContainingMapOrArray() {
        return this.argumentIndicesContainingMapOrArray;
    }

    public List<LambdaDescriptor> getLambdaDescriptors() {
        return this.lambdaDescriptors;
    }

    public boolean isAcceptingLambdaArgument() {
        return !this.lambdaDescriptors.isEmpty();
    }

    public Optional<Function<Set<Subfield>, Set<Subfield>>> getOutputToInputTransformationFunction() {
        return this.outputToInputTransformationFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComplexTypeFunctionDescriptor that = (ComplexTypeFunctionDescriptor)o;
        return this.isAccessingInputValues == that.isAccessingInputValues && Objects.equals(this.argumentIndicesContainingMapOrArray, that.argumentIndicesContainingMapOrArray) && Objects.equals(this.outputToInputTransformationFunction, that.outputToInputTransformationFunction) && Objects.equals(this.lambdaDescriptors, that.lambdaDescriptors);
    }

    public int hashCode() {
        return Objects.hash(this.isAccessingInputValues, this.argumentIndicesContainingMapOrArray, this.outputToInputTransformationFunction, this.lambdaDescriptors);
    }

    public static Set<Subfield> prependAllSubscripts(Set<Subfield> subfields) {
        return subfields.stream().map(subfield -> new Subfield(subfield.getRootName(), Collections.unmodifiableList(Stream.concat(Stream.of(Subfield.allSubscripts()), subfield.getPath().stream()).collect(Collectors.toList())))).collect(Collectors.toSet());
    }

    public static Set<Subfield> allSubfieldsRequired(Set<Subfield> subfields) {
        if (subfields.isEmpty()) {
            return Collections.unmodifiableSet(Stream.of(new Subfield("", Arrays.asList(Subfield.allSubscripts()))).collect(Collectors.toSet()));
        }
        return subfields;
    }

    public static Set<Subfield> clearRequiredSubfields(Set<Subfield> ignored) {
        return Collections.emptySet();
    }

    public static Set<Subfield> removeSecondPathElement(Set<Subfield> subfields) {
        return subfields.stream().map(subfield -> new Subfield(subfield.getRootName(), Collections.unmodifiableList(Stream.concat(Stream.of(subfield.getPath().get(0)), subfield.getPath().stream().skip(2L)).collect(Collectors.toList())))).collect(Collectors.toSet());
    }
}

