/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.plan.EquiJoinClause;
import com.facebook.presto.spi.plan.JoinDistributionType;
import com.facebook.presto.spi.plan.JoinType;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ConnectorJoinNode
extends PlanNode {
    private final List<PlanNode> sources;
    private final JoinType type;
    private final Set<EquiJoinClause> criteria;
    private final Set<RowExpression> filters;
    private final Optional<JoinDistributionType> distributionType;
    private final List<VariableReferenceExpression> outputVariables;

    public ConnectorJoinNode(PlanNodeId id, List<PlanNode> sources, Optional<PlanNode> statsEquivalentPlanNode, JoinType type, Set<EquiJoinClause> criteria, Set<RowExpression> filters, Optional<JoinDistributionType> distributionType, List<VariableReferenceExpression> outputVariables) {
        super(Optional.empty(), id, statsEquivalentPlanNode);
        this.sources = Objects.requireNonNull(sources, "sources is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.criteria = Objects.requireNonNull(criteria, "criteria is null");
        this.filters = Objects.requireNonNull(filters, "filters is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.outputVariables = Objects.requireNonNull(outputVariables, "outputVariables is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return this.sources;
    }

    public JoinType getType() {
        return this.type;
    }

    public Set<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    public Set<RowExpression> getFilters() {
        return this.filters;
    }

    public Optional<JoinDistributionType> getDistributionType() {
        return this.distributionType;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ConnectorJoinNode(this.getId(), newChildren, this.getStatsEquivalentPlanNode(), this.type, this.criteria, this.filters, this.distributionType, this.outputVariables);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new ConnectorJoinNode(this.getId(), this.getSources(), this.getStatsEquivalentPlanNode(), this.getType(), this.getCriteria(), this.getFilters(), this.getDistributionType(), this.outputVariables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorJoinNode that = (ConnectorJoinNode)o;
        return Objects.equals(this.sources, that.sources) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.criteria, that.criteria) && Objects.equals(this.filters, that.filters) && Objects.equals(this.outputVariables, that.outputVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sources, this.type, this.criteria, this.filters, this.outputVariables});
    }

    public String toString() {
        return "ConnectorJoinNode{sources=" + this.sources + ", type=" + (Object)((Object)this.type) + ", criteria=" + this.criteria + ", filters=" + this.filters + ", outputVariables=" + this.outputVariables + '}';
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitConnectorJoinNode(this, context);
    }
}

