/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExistsExpression;
import com.facebook.presto.spi.relation.InSubqueryExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.QuantifiedComparisonExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.UnresolvedSymbolExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;

public interface RowExpressionVisitor<R, C> {
    default public R visitExpression(RowExpression expression, C context) {
        throw new UnsupportedOperationException(String.format("Unimplemented RowExpression visitor for %s", expression.getClass()));
    }

    default public R visitCall(CallExpression call, C context) {
        return this.visitExpression(call, context);
    }

    default public R visitInputReference(InputReferenceExpression reference, C context) {
        return this.visitExpression(reference, context);
    }

    default public R visitConstant(ConstantExpression literal, C context) {
        return this.visitExpression(literal, context);
    }

    default public R visitLambda(LambdaDefinitionExpression lambda, C context) {
        return this.visitExpression(lambda, context);
    }

    default public R visitVariableReference(VariableReferenceExpression reference, C context) {
        return this.visitExpression(reference, context);
    }

    default public R visitSpecialForm(SpecialFormExpression specialForm, C context) {
        return this.visitExpression(specialForm, context);
    }

    default public R visitIntermediateFormExpression(IntermediateFormExpression intermediateFormExpression, C context) {
        return this.visitExpression(intermediateFormExpression, context);
    }

    default public R visitInSubqueryExpression(InSubqueryExpression inSubqueryRowExpression, C context) {
        return this.visitIntermediateFormExpression(inSubqueryRowExpression, context);
    }

    default public R visitQuantifiedComparisonExpression(QuantifiedComparisonExpression quantifiedComparisonRowExpression, C context) {
        return this.visitIntermediateFormExpression(quantifiedComparisonRowExpression, context);
    }

    default public R visitExistsExpression(ExistsExpression existsRowExpression, C context) {
        return this.visitIntermediateFormExpression(existsRowExpression, context);
    }

    default public R visitUnresolvedSymbolExpression(UnresolvedSymbolExpression unresolvedSymbolExpression, C context) {
        return this.visitIntermediateFormExpression(unresolvedSymbolExpression, context);
    }
}

