/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.facebook.presto.spi.security.ConnectorIdentity;
import com.facebook.presto.spi.security.SelectedRole;
import com.facebook.presto.spi.security.TokenAuthenticator;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Identity {
    private final String user;
    private final Optional<Principal> principal;
    private final Map<String, SelectedRole> roles;
    private final Map<String, String> extraCredentials;
    private final Optional<String> selectedUser;
    private final Optional<String> reasonForSelect;
    private final Map<String, TokenAuthenticator> extraAuthenticators;

    public Identity(Identity other) {
        this.user = other.user;
        this.principal = other.principal;
        this.roles = other.roles;
        this.extraCredentials = other.extraCredentials;
        this.extraAuthenticators = other.extraAuthenticators;
        this.selectedUser = other.selectedUser;
        this.reasonForSelect = other.reasonForSelect;
    }

    public Identity(String user, Optional<Principal> principal) {
        this(user, principal, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Optional.empty(), Optional.empty());
    }

    public Identity(String user, Optional<Principal> principal, Map<String, String> extraCredentials) {
        this(user, principal, Collections.emptyMap(), extraCredentials, Collections.emptyMap(), Optional.empty(), Optional.empty());
    }

    public Identity(String user, Optional<Principal> principal, Map<String, SelectedRole> roles, Map<String, String> extraCredentials, Map<String, TokenAuthenticator> extraAuthenticators, Optional<String> selectedUser, Optional<String> reasonForSelect) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.roles = Collections.unmodifiableMap(Objects.requireNonNull(roles, "roles is null"));
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
        this.extraAuthenticators = Collections.unmodifiableMap(new HashMap<String, TokenAuthenticator>(Objects.requireNonNull(extraAuthenticators, "extraAuthenticators is null")));
        this.selectedUser = Objects.requireNonNull(selectedUser, "selectedUser is null");
        this.reasonForSelect = Objects.requireNonNull(reasonForSelect, "reasonForSelect is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Map<String, SelectedRole> getRoles() {
        return this.roles;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public Map<String, TokenAuthenticator> getExtraAuthenticators() {
        return this.extraAuthenticators;
    }

    public Optional<String> getSelectedUser() {
        return this.selectedUser;
    }

    public Optional<String> getReasonForSelect() {
        return this.reasonForSelect;
    }

    public ConnectorIdentity toConnectorIdentity() {
        return new ConnectorIdentity(this.user, this.principal, Optional.empty(), this.extraCredentials, this.extraAuthenticators, this.selectedUser, this.reasonForSelect);
    }

    public ConnectorIdentity toConnectorIdentity(String catalog) {
        Objects.requireNonNull(catalog, "catalog is null");
        return new ConnectorIdentity(this.user, this.principal, Optional.ofNullable(this.roles.get(catalog)), this.extraCredentials, this.extraAuthenticators, this.selectedUser, this.reasonForSelect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identity identity = (Identity)o;
        return Objects.equals(this.user, identity.user);
    }

    public int hashCode() {
        return Objects.hash(this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Identity{");
        sb.append("user='").append(this.user).append('\'');
        this.principal.ifPresent(principal -> sb.append(", principal=").append(principal));
        sb.append(", roles=").append(this.roles);
        sb.append(", extraCredentials=").append(this.extraCredentials.keySet());
        sb.append(", extraAuthenticators=").append(this.extraAuthenticators.keySet());
        this.selectedUser.ifPresent(user -> sb.append(", selectedUser=").append((String)user));
        this.reasonForSelect.ifPresent(reason -> sb.append(", reasonForSelect=").append((String)reason));
        sb.append('}');
        return sb.toString();
    }
}

