/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

@ThriftStruct
public final class Estimate {
    private static final Estimate UNKNOWN = new Estimate(Double.NaN);
    private static final Estimate ZERO = new Estimate(0.0);
    private final double value;

    public static Estimate unknown() {
        return UNKNOWN;
    }

    public static Estimate zero() {
        return ZERO;
    }

    public static Estimate of(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value is NaN");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("value is infinite");
        }
        return new Estimate(value);
    }

    public static Estimate estimateFromDouble(double value) {
        if (Double.isNaN(value)) {
            return Estimate.unknown();
        }
        return Estimate.of(value);
    }

    @JsonCreator
    @ThriftConstructor
    public Estimate(@JsonProperty(value="value") double value) {
        this.value = value;
    }

    public boolean isUnknown() {
        return Double.isNaN(this.value);
    }

    @JsonProperty
    @ThriftField(value=1)
    public double getValue() {
        return this.value;
    }

    public Estimate map(Function<Double, Double> mapper) {
        if (!this.isUnknown()) {
            return Estimate.of(mapper.apply(this.value));
        }
        return this;
    }

    public Estimate flatMap(Function<Double, Estimate> mapper) {
        if (!this.isUnknown()) {
            return mapper.apply(this.value);
        }
        return this;
    }

    public Estimate or(Supplier<Estimate> supplier) {
        if (this.isUnknown()) {
            return supplier.get();
        }
        return this;
    }

    public double orElse(Supplier<Double> supplier) {
        if (this.isUnknown()) {
            return supplier.get();
        }
        return this.getValue();
    }

    public boolean fuzzyEquals(Estimate other, double tolerance) {
        if (this.equals(other)) {
            return true;
        }
        if (this.isUnknown() || other.isUnknown()) {
            return false;
        }
        return Math.copySign(this.value - other.value, 1.0) <= tolerance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Estimate estimate = (Estimate)o;
        return Double.compare(estimate.value, this.value) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

