/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.TableConstraintsHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConnectorTableMetadata {
    private final SchemaTableName table;
    private final Optional<String> comment;
    private final List<ColumnMetadata> columns;
    private final Map<String, Object> properties;
    private final TableConstraintsHolder tableConstraintsHolder;

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns) {
        this(table, columns, Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties) {
        this(table, columns, properties, Optional.empty(), Collections.emptyList(), Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment) {
        this(table, columns, properties, comment, Collections.emptyList(), Collections.emptyMap());
    }

    public ConnectorTableMetadata(SchemaTableName table, List<ColumnMetadata> columns, Map<String, Object> properties, Optional<String> comment, List<TableConstraint<String>> tableConstraints, Map<String, ColumnHandle> columnNameToHandleAssignments) {
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(comment, "comment is null");
        this.table = table;
        this.columns = Collections.unmodifiableList(new ArrayList<ColumnMetadata>(columns));
        this.properties = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(properties));
        this.comment = comment;
        this.tableConstraintsHolder = new TableConstraintsHolder(tableConstraints, columnNameToHandleAssignments);
    }

    public SchemaTableName getTable() {
        return this.table;
    }

    public List<ColumnMetadata> getColumns() {
        return this.columns;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public TableConstraintsHolder getTableConstraintsHolder() {
        return this.tableConstraintsHolder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorTableMetadata{");
        sb.append("table=").append(this.table);
        sb.append(", columns=").append(this.columns);
        sb.append(", tableConstraints=").append(this.tableConstraintsHolder.getTableConstraints());
        sb.append(", properties=").append(this.properties);
        this.comment.ifPresent(value -> sb.append(", comment='").append((String)value).append("'"));
        sb.append('}');
        return sb.toString();
    }
}

