/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;

public class PrestoException
extends RuntimeException {
    private final ErrorCode errorCode;

    public PrestoException(ErrorCodeSupplier errorCodeSupplier, String message) {
        this(errorCodeSupplier, message, null);
    }

    public PrestoException(ErrorCodeSupplier errorCodeSupplier, Throwable throwable) {
        this(errorCodeSupplier, null, throwable);
    }

    public PrestoException(ErrorCodeSupplier errorCodeSupplier, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCodeSupplier.toErrorCode();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (message == null && this.getCause() != null) {
            message = this.getCause().getMessage();
        }
        if (message == null) {
            message = this.errorCode.getName();
        }
        return message;
    }
}

