/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.analyzer;

import com.facebook.presto.common.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ViewDefinition {
    private final String originalSql;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<ViewColumn> columns;
    private final Optional<String> owner;
    private final boolean runAsInvoker;

    @JsonCreator
    public ViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="columns") List<ViewColumn> columns, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="runAsInvoker") boolean runAsInvoker) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = Collections.unmodifiableList(Objects.requireNonNull(columns, "columns is null"));
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.runAsInvoker = runAsInvoker;
        if (runAsInvoker && owner.isPresent()) {
            throw new IllegalArgumentException("owner cannot be present with runAsInvoker");
        }
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public boolean isRunAsInvoker() {
        return this.runAsInvoker;
    }

    public String toString() {
        return "ViewDefinition{originalSql='" + this.originalSql + '\'' + ", catalog=" + (String)this.catalog.orElse(null) + ", schema=" + (String)this.schema.orElse(null) + ", columns=" + this.columns + ", owner=" + (String)this.owner.orElse(null) + ", runAsInvoker=" + this.runAsInvoker + '}';
    }

    public ViewDefinition withOwner(String owner) {
        return new ViewDefinition(this.originalSql, this.catalog, this.schema, this.columns, Optional.of(owner), this.runAsInvoker);
    }

    public static final class ViewColumn {
        private final String name;
        private final Type type;

        @JsonCreator
        public ViewColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public Type getType() {
            return this.type;
        }

        public String toString() {
            return this.name + ":" + this.type;
        }
    }
}

