/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.constraints;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.constraints.NotNullConstraint;
import com.facebook.presto.spi.constraints.TableConstraint;
import com.facebook.presto.spi.constraints.UniqueConstraint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TableConstraintsHolder {
    private final List<TableConstraint<String>> tableConstraints;
    private final Map<String, ColumnHandle> columnNameToHandleAssignments;

    public TableConstraintsHolder(List<TableConstraint<String>> tableConstraints, Map<String, ColumnHandle> columnNameToHandleAssignments) {
        Objects.requireNonNull(tableConstraints, "tableConstraints is null");
        Objects.requireNonNull(columnNameToHandleAssignments, "columnNameToHandleAssignments is null");
        TableConstraintsHolder.validateTableConstraints(tableConstraints);
        this.tableConstraints = Collections.unmodifiableList(new ArrayList<TableConstraint<String>>(tableConstraints));
        this.columnNameToHandleAssignments = Collections.unmodifiableMap(columnNameToHandleAssignments);
    }

    public static void validateTableConstraints(Collection<TableConstraint<String>> constraints) {
        constraints.forEach(constraint -> {
            if (!(constraint instanceof UniqueConstraint) && !(constraint instanceof NotNullConstraint)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Constraint %s of unknown type (%s) is not supported", constraint.getName().orElse(""), constraint.getClass().getName()));
            }
        });
    }

    public List<TableConstraint<String>> getTableConstraints() {
        return this.tableConstraints;
    }

    public List<TableConstraint<ColumnHandle>> getTableConstraintsWithColumnHandles() {
        if (this.columnNameToHandleAssignments.isEmpty()) {
            return Collections.emptyList();
        }
        return this.rebaseTableConstraints(this.tableConstraints, this.columnNameToHandleAssignments);
    }

    private <T, R> List<TableConstraint<R>> rebaseTableConstraints(List<TableConstraint<T>> tableConstraints, Map<T, R> assignments) {
        ArrayList mappedTableConstraints = new ArrayList();
        tableConstraints.stream().forEach(tableConstraint -> {
            Optional mappedConstraint = tableConstraint.rebaseConstraint(assignments);
            if (mappedConstraint.isPresent()) {
                mappedTableConstraints.add(mappedConstraint.get());
            }
        });
        return mappedTableConstraints;
    }
}

