/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CteReferenceNode
extends PlanNode {
    private final PlanNode source;
    private final String cteId;

    @JsonCreator
    public CteReferenceNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="cteName") String cteId) {
        this(sourceLocation, id, Optional.empty(), source, cteId);
    }

    public CteReferenceNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, String cteId) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.cteId = Objects.requireNonNull(cteId, "cteName must not be null");
        this.source = Objects.requireNonNull(source, "source must not be null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Objects.requireNonNull(newChildren, "newChildren is null");
        CteReferenceNode.checkArgument(newChildren.size() == 1, "expected newChildren to contain 1 node");
        return new CteReferenceNode(newChildren.get(0).getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.cteId);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new CteReferenceNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.cteId);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitCteReference(this, context);
    }

    public String getCteId() {
        return this.cteId;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

