/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Partitioning {
    private final PartitioningHandle handle;
    private final List<RowExpression> arguments;

    public Partitioning(PartitioningHandle handle, List<RowExpression> arguments) {
        this.handle = Objects.requireNonNull(handle, "handle is null");
        this.arguments = Collections.unmodifiableList(Objects.requireNonNull(arguments, "arguments is null"));
    }

    public static <T extends RowExpression> Partitioning create(PartitioningHandle handle, Collection<T> columns) {
        return new Partitioning(handle, columns.stream().map(RowExpression.class::cast).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)));
    }

    @JsonCreator
    public static Partitioning jsonCreate(@JsonProperty(value="handle") PartitioningHandle handle, @JsonProperty(value="arguments") List<RowExpression> arguments) {
        return new Partitioning(handle, arguments);
    }

    @JsonProperty
    public PartitioningHandle getHandle() {
        return this.handle;
    }

    @JsonProperty
    public List<RowExpression> getArguments() {
        return this.arguments;
    }

    public Set<VariableReferenceExpression> getVariableReferences() {
        return this.arguments.stream().filter(VariableReferenceExpression.class::isInstance).map(VariableReferenceExpression.class::cast).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public Partitioning withAlternativePartitioningHandle(PartitioningHandle partitioningHandle) {
        return new Partitioning(partitioningHandle, this.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.arguments);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Partitioning other = (Partitioning)obj;
        return Objects.equals(this.handle, other.handle) && Objects.equals(this.arguments, other.arguments);
    }

    public String toString() {
        String sb = "Partitioning{handle=" + this.handle + ", arguments=" + this.arguments + '}';
        return sb;
    }
}

