/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.common.Utils;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitioningScheme {
    private final Partitioning partitioning;
    private final List<VariableReferenceExpression> outputLayout;
    private final Optional<VariableReferenceExpression> hashColumn;
    private final boolean replicateNullsAndAny;
    private final Optional<int[]> bucketToPartition;

    public PartitioningScheme(Partitioning partitioning, List<VariableReferenceExpression> outputLayout) {
        this(partitioning, outputLayout, Optional.empty(), false, Optional.empty());
    }

    public PartitioningScheme(Partitioning partitioning, List<VariableReferenceExpression> outputLayout, Optional<VariableReferenceExpression> hashColumn) {
        this(partitioning, outputLayout, hashColumn, false, Optional.empty());
    }

    @JsonCreator
    public PartitioningScheme(@JsonProperty(value="partitioning") Partitioning partitioning, @JsonProperty(value="outputLayout") List<VariableReferenceExpression> outputLayout, @JsonProperty(value="hashColumn") Optional<VariableReferenceExpression> hashColumn, @JsonProperty(value="replicateNullsAndAny") boolean replicateNullsAndAny, @JsonProperty(value="bucketToPartition") Optional<int[]> bucketToPartition) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.outputLayout = Collections.unmodifiableList(Objects.requireNonNull(outputLayout, "outputLayout is null"));
        Set<VariableReferenceExpression> columns = partitioning.getVariableReferences();
        Set<VariableReferenceExpression> outputLayoutSet = Collections.unmodifiableSet(new HashSet<VariableReferenceExpression>(outputLayout));
        Utils.checkArgument((boolean)outputLayoutSet.containsAll(columns), (String)String.format("Output layout (%s) don't include all partition columns (%s)", outputLayout, columns));
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        hashColumn.ifPresent(column -> Utils.checkArgument((boolean)outputLayout.contains(column), (String)String.format("Output layout (%s) don't include hash column (%s)", outputLayout, column)));
        Utils.checkArgument((!replicateNullsAndAny || columns.size() <= 1 ? 1 : 0) != 0, (String)"Must have at most one partitioning column when nullPartition is REPLICATE.");
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
    }

    @JsonProperty
    public Partitioning getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNullsAndAny() {
        return this.replicateNullsAndAny;
    }

    @JsonProperty
    public Optional<int[]> getBucketToPartition() {
        return this.bucketToPartition;
    }

    public PartitioningScheme withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PartitioningScheme(this.partitioning, this.outputLayout, this.hashColumn, this.replicateNullsAndAny, bucketToPartition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitioningScheme that = (PartitioningScheme)o;
        return Objects.equals(this.partitioning, that.partitioning) && Objects.equals(this.outputLayout, that.outputLayout) && this.replicateNullsAndAny == that.replicateNullsAndAny && Objects.equals(this.bucketToPartition, that.bucketToPartition);
    }

    public int hashCode() {
        return Objects.hash(this.partitioning, this.outputLayout, this.replicateNullsAndAny, this.bucketToPartition);
    }

    public String toString() {
        String sb = "ConnectorTableMetadata{partitioning=" + this.partitioning + ", outputLayout=" + this.outputLayout + ", hashChannel=" + this.hashColumn + ", replicateNullsAndAny=" + this.replicateNullsAndAny + ", bucketToPartition=" + this.bucketToPartition + '}';
        return sb;
    }
}

