/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ValuesNode
extends PlanNode {
    private final List<VariableReferenceExpression> outputVariables;
    private final List<List<RowExpression>> rows;
    private final Optional<String> valuesNodeLabel;

    @JsonCreator
    public ValuesNode(@JsonProperty(value="location") Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="rows") List<List<RowExpression>> rows, @JsonProperty(value="valuesNodeLabel") Optional<String> valuesNodeLabel) {
        this(sourceLocation, id, Optional.empty(), outputVariables, rows, valuesNodeLabel);
    }

    public ValuesNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, List<VariableReferenceExpression> outputVariables, List<List<RowExpression>> rows, Optional<String> valuesNodeLabel) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.outputVariables = ValuesNode.immutableListCopyOf(outputVariables);
        this.rows = ValuesNode.immutableListCopyOf(Objects.requireNonNull(rows, "lists is null").stream().map(ValuesNode::immutableListCopyOf).collect(Collectors.toList()));
        for (List<RowExpression> row : rows) {
            if (row.size() == outputVariables.size() || row.isEmpty()) continue;
            throw new IllegalArgumentException(String.format("Expected row to have %s values, but row has %s values", outputVariables.size(), row.size()));
        }
        this.valuesNodeLabel = valuesNodeLabel;
    }

    public Optional<String> getValuesNodeLabel() {
        return this.valuesNodeLabel;
    }

    @JsonProperty
    public List<List<RowExpression>> getRows() {
        return this.rows;
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getValuesProperties(this);
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new ValuesNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.outputVariables, this.rows, this.valuesNodeLabel);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        if (!newChildren.isEmpty()) {
            throw new IllegalArgumentException("newChildren is not empty");
        }
        return this;
    }

    private static <T> List<T> immutableListCopyOf(List<T> list) {
        return Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(list, "list is null")));
    }
}

