/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.relation;

import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.relation.IntermediateFormExpression;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ExistsExpression
extends IntermediateFormExpression {
    private final RowExpression subquery;

    public ExistsExpression(Optional<SourceLocation> sourceLocation, RowExpression subquery) {
        super(sourceLocation);
        this.subquery = Objects.requireNonNull(subquery, "subquery is null");
    }

    public RowExpression getSubquery() {
        return this.subquery;
    }

    @Override
    public Type getType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public List<RowExpression> getChildren() {
        return Collections.singletonList(this.subquery);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExistsExpression other = (ExistsExpression)obj;
        return Objects.equals(this.subquery, other.subquery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.subquery);
    }

    @Override
    public String toString() {
        return String.format("%s", this.subquery);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitExistsExpression(this, context);
    }

    @Override
    public RowExpression canonicalize() {
        return this;
    }
}

