/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.security;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.transaction.TransactionId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AccessControlContext;
import com.facebook.presto.spi.security.DenyAllAccessControl;
import com.facebook.presto.spi.security.Identity;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ViewAccessControl
extends DenyAllAccessControl {
    private final AccessControl delegate;

    public ViewAccessControl(AccessControl delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<Subfield> columnOrSubfieldNames) {
        this.delegate.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, columnOrSubfieldNames.stream().map(Subfield::getRootName).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet)));
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, AccessControlContext context, QualifiedObjectName tableName, Set<String> columnNames) {
        this.delegate.checkCanCreateViewWithSelectFromColumns(transactionId, identity, context, tableName, columnNames);
    }
}

