/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.session;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.session.SessionPropertyMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSessionPropertyMetadata {
    public static final JsonCodec<SessionPropertyMetadata> CODEC = JsonCodec.jsonCodec(SessionPropertyMetadata.class);

    @Test
    public void testBool() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"boolean\",\n  \"defaultValue\" : \"false\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", BooleanType.BOOLEAN.getTypeSignature(), "false", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }

    @Test
    public void testInteger() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"integer\",\n  \"defaultValue\" : \"0\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", IntegerType.INTEGER.getTypeSignature(), "0", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }

    @Test
    public void testLong() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"bigint\",\n  \"defaultValue\" : \"987654321012345678\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", BigintType.BIGINT.getTypeSignature(), "987654321012345678", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }

    @Test
    public void testDouble() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"double\",\n  \"defaultValue\" : \"0.0\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", DoubleType.DOUBLE.getTypeSignature(), "0.0", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }

    @Test
    public void testString() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"varchar\",\n  \"defaultValue\" : \"defaultValue\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", VarcharType.VARCHAR.getTypeSignature(), "defaultValue", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }

    @Test
    public void testDataSize() {
        String jsonString = "{\n  \"name\" : \"test\",\n  \"description\" : \"test description\",\n  \"typeSignature\" : \"varchar\",\n  \"defaultValue\" : \"1MB\",\n  \"hidden\" : false\n}";
        SessionPropertyMetadata actual = new SessionPropertyMetadata("test", "test description", VarcharType.VARCHAR.getTypeSignature(), "1MB", false);
        SessionPropertyMetadata expected = (SessionPropertyMetadata)CODEC.fromJson(CODEC.toJson((Object)actual));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((String)CODEC.toJson((Object)actual), (String)jsonString);
    }
}

