/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import io.airlift.slice.SizeOf;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.GraphLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColumnStatistics {
    @Test
    public void testColumnStatisticsEstimatedSizeAccuracySimple() {
        ColumnStatistics stats = ColumnStatistics.builder().setDataSize(Estimate.of((double)100.0)).setDistinctValuesCount(Estimate.of((double)1.0)).setRange(new DoubleRange(100.0, 100.0)).setNullsFraction(Estimate.of((double)0.1)).build();
        long actualSize = GraphLayout.parseInstance((Object)stats).totalSize();
        Assert.assertEquals((long)actualSize, (long)stats.getEstimatedSize());
    }

    @Test
    public void testColumnStatisticsEstimatedSizeAccuracyHistogramEmpty() {
        ColumnStatistics stats = ColumnStatistics.builder().setDataSize(Estimate.of((double)100.0)).setDistinctValuesCount(Estimate.of((double)1.0)).setRange(new DoubleRange(100.0, 100.0)).setNullsFraction(Estimate.of((double)0.1)).setHistogram(Optional.of(new ConnectorHistogram(){

            public Estimate cumulativeProbability(double value, boolean inclusive) {
                return null;
            }

            public Estimate inverseCumulativeProbability(double percentile) {
                return null;
            }

            public long getEstimatedSize() {
                return (long)ClassLayout.parseClass(this.getClass()).instanceSize() * 2L;
            }
        })).build();
        long actualSize = GraphLayout.parseInstance((Object)stats).totalSize();
        Assert.assertEquals((long)actualSize, (long)stats.getEstimatedSize());
    }

    @Test
    public void testColumnStatisticsEstimatedSizeAccuracyHistogram() {
        ColumnStatistics stats = ColumnStatistics.builder().setDataSize(Estimate.of((double)100.0)).setDistinctValuesCount(Estimate.of((double)1.0)).setRange(new DoubleRange(100.0, 100.0)).setNullsFraction(Estimate.of((double)0.1)).setHistogram(Optional.of(new ConnectorHistogram(){
            final byte[] memory = new byte[4096];

            public Estimate cumulativeProbability(double value, boolean inclusive) {
                return null;
            }

            public Estimate inverseCumulativeProbability(double percentile) {
                return null;
            }

            public long getEstimatedSize() {
                return SizeOf.sizeOf((byte[])this.memory) + (long)ClassLayout.parseClass(this.getClass()).instanceSize() * 2L;
            }
        })).build();
        long actualSize = GraphLayout.parseInstance((Object)stats).totalSize();
        double error = (double)actualSize * 0.01;
        Assert.assertEquals((double)actualSize, (double)stats.getEstimatedSize(), (double)error);
    }
}

