/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.DisjointRangeDomainHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TestHistogram;
import com.facebook.presto.spi.statistics.UniformDistributionHistogram;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDisjointRangeDomainHistogram
extends TestHistogram {
    @Test
    public void testBasicDisjointRanges() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        ConnectorHistogram constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (Range)TestDisjointRangeDomainHistogram.rangeOpen(0.0, 25.0));
        constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)constrained, (Range)TestDisjointRangeDomainHistogram.rangeOpen(75.0, 100.0));
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)87.5);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)0.0);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)100.0);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)25.0);
    }

    @Test
    public void testSingleDisjointRange() {
        int i;
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 10.0);
        ConnectorHistogram constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (Range)TestDisjointRangeDomainHistogram.rangeOpen(-10.0, -5.0));
        for (i = -11; i < 12; ++i) {
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, true).getValue(), (double)0.0, (double)1.0E-8);
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, false).getValue(), (double)0.0, (double)1.0E-8);
        }
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(0.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(1.0), (Object)Estimate.unknown());
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)TestDisjointRangeDomainHistogram.rangeOpen(-2.0, 2.0)));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.5, false).getValue(), (double)0.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(2.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)1.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)2.0, (double)1.0E-8);
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)TestDisjointRangeDomainHistogram.rangeOpen(3.0, 4.0)));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.5, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(4.5, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)3.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)3.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)3.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)4.0, (double)1.0E-8);
        constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)TestDisjointRangeDomainHistogram.rangeOpen(8.0, 12.0)));
        Assert.assertEquals((double)constrained.cumulativeProbability(-3.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(5.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(8.0, false).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(9.0, false).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(9.5, false).getValue(), (double)0.75, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(10.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(11.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(12.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(13.0, false).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)8.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)9.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)9.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)10.0, (double)1.0E-8);
        constrained = DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (Range)TestDisjointRangeDomainHistogram.rangeOpen(15.0, 20.0));
        for (i = 15; i < 20; ++i) {
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, true).getValue(), (double)0.0, (double)1.0E-8);
            Assert.assertEquals((double)constrained.cumulativeProbability((double)i, false).getValue(), (double)0.0, (double)1.0E-8);
        }
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(0.0), (Object)Estimate.unknown());
        Assert.assertEquals((Object)constrained.inverseCumulativeProbability(1.0), (Object)Estimate.unknown());
    }

    @Test
    public void testMultipleDisjunction() {
        StandardNormalHistogram source = new StandardNormalHistogram();
        NormalDistribution dist = source.getDistribution();
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction(source, TestDisjointRangeDomainHistogram.rangeClosed(-2.0, -1.0));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, TestDisjointRangeDomainHistogram.rangeClosed(1.0, 2.0));
        double rangeLeftProb = dist.cumulativeProbability(-1.0) - dist.cumulativeProbability(-2.0);
        double rangeRightProb = dist.cumulativeProbability(2.0) - dist.cumulativeProbability(1.0);
        double sumRangeProb = rangeLeftProb + rangeRightProb;
        Assert.assertEquals((double)constrained.cumulativeProbability(-2.0, true).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.5, true).getValue(), (double)((dist.cumulativeProbability(-1.5) - dist.cumulativeProbability(-2.0)) / sumRangeProb), (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.5, true).getValue(), (double)(rangeLeftProb / sumRangeProb + (dist.cumulativeProbability(1.5) - dist.cumulativeProbability(1.0)) / sumRangeProb));
        Assert.assertEquals((double)constrained.cumulativeProbability(2.0, true).getValue(), (double)1.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(3.0, true).getValue(), (double)1.0, (double)1.0E-8);
    }

    @Test
    public void testNormalDistribution() {
        StandardNormalHistogram source = new StandardNormalHistogram();
        NormalDistribution dist = source.getDistribution();
        DisjointRangeDomainHistogram constrained = new DisjointRangeDomainHistogram((ConnectorHistogram)source, (Set)ImmutableSet.of((Object)TestDisjointRangeDomainHistogram.rangeOpen(-1.0, 1.0)));
        Assert.assertEquals((double)constrained.cumulativeProbability(-1.0, true).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.0, true).getValue(), (double)0.5, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(1.0, true).getValue(), (double)1.0, (double)1.0E-8);
        double probability = (dist.cumulativeProbability(-0.5) - dist.cumulativeProbability(-1.0)) / (dist.cumulativeProbability(1.0) - dist.cumulativeProbability(-1.0));
        Assert.assertEquals((double)constrained.cumulativeProbability(-0.5, true).getValue(), (double)probability, (double)1.0E-8);
        Assert.assertEquals((double)constrained.cumulativeProbability(0.5, true).getValue(), (double)(probability + (1.0 - 2.0 * probability)), (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.0).getValue(), (double)-1.0, (double)1.0E-8);
        probability = dist.inverseCumulativeProbability(dist.cumulativeProbability(-1.0) + 0.25 * (dist.cumulativeProbability(1.0) - dist.cumulativeProbability(-1.0)));
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.25).getValue(), (double)-0.44177054668, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.5).getValue(), (double)0.0, (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(0.75).getValue(), (double)(-1.0 * probability), (double)1.0E-8);
        Assert.assertEquals((double)constrained.inverseCumulativeProbability(1.0).getValue(), (double)1.0, (double)1.0E-8);
    }

    @Test
    public void testAddDisjunction() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)source, TestDisjointRangeDomainHistogram.rangeOpen(-1.0, 2.0));
        Assert.assertEquals((int)constrained.getRanges().getOrderedRanges().size(), (int)1);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)2.0, (boolean)false));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, TestDisjointRangeDomainHistogram.rangeOpen(1.0, 10.0));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)10.0, (boolean)false));
        constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)constrained, Range.range((Type)DoubleType.DOUBLE, (Object)50.0, (boolean)true, (Object)100.0, (boolean)false));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)2);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)10.0, (boolean)false));
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(1), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)50.0, (boolean)true, (Object)100.0, (boolean)false));
    }

    @Test
    public void testAddConjunction() {
        UniformDistributionHistogram source = new UniformDistributionHistogram(0.0, 100.0);
        DisjointRangeDomainHistogram constrained = TestDisjointRangeDomainHistogram.disjunction((ConnectorHistogram)source, TestDisjointRangeDomainHistogram.rangeOpen(10.0, 90.0));
        Assert.assertEquals((int)constrained.getRanges().getOrderedRanges().size(), (int)1);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)TestDisjointRangeDomainHistogram.rangeOpen(10.0, 90.0));
        constrained = TestDisjointRangeDomainHistogram.conjunction((ConnectorHistogram)constrained, Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)50.0));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)Range.range((Type)DoubleType.DOUBLE, (Object)10.0, (boolean)false, (Object)50.0, (boolean)true));
        constrained = TestDisjointRangeDomainHistogram.conjunction((ConnectorHistogram)constrained, Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)25.0));
        Assert.assertEquals((int)TestDisjointRangeDomainHistogram.ranges(constrained).size(), (int)1);
        Assert.assertEquals((Object)TestDisjointRangeDomainHistogram.ranges(constrained).get(0), (Object)TestDisjointRangeDomainHistogram.rangeClosed(25.0, 50.0));
    }

    private static DisjointRangeDomainHistogram disjunction(ConnectorHistogram source, Range range) {
        return (DisjointRangeDomainHistogram)DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (Range)range);
    }

    private static DisjointRangeDomainHistogram conjunction(ConnectorHistogram source, Range range) {
        return (DisjointRangeDomainHistogram)DisjointRangeDomainHistogram.addConjunction((ConnectorHistogram)source, (Range)range);
    }

    private static List<Range> ranges(DisjointRangeDomainHistogram hist) {
        return hist.getRanges().getOrderedRanges();
    }

    private static Range rangeOpen(double low, double high) {
        return Range.range((Type)DoubleType.DOUBLE, (Object)low, (boolean)false, (Object)high, (boolean)false);
    }

    private static Range rangeClosed(double low, double high) {
        return Range.range((Type)DoubleType.DOUBLE, (Object)low, (boolean)true, (Object)high, (boolean)true);
    }

    @Override
    ConnectorHistogram createHistogram() {
        RealDistribution distribution = this.getDistribution();
        return new DisjointRangeDomainHistogram((ConnectorHistogram)new UniformDistributionHistogram(distribution.getSupportLowerBound(), distribution.getSupportUpperBound())).addDisjunction(TestDisjointRangeDomainHistogram.rangeClosed(0.0, 100.0));
    }

    @Override
    double getDistinctValues() {
        return 100.0;
    }

    @Override
    RealDistribution getDistribution() {
        return new UniformRealDistribution(0.0, 100.0);
    }

    @Override
    public void testInclusiveExclusive() {
    }

    private static class StandardNormalHistogram
    implements ConnectorHistogram {
        private final NormalDistribution distribution = new NormalDistribution();

        private StandardNormalHistogram() {
        }

        public NormalDistribution getDistribution() {
            return this.distribution;
        }

        public Estimate cumulativeProbability(double value, boolean inclusive) {
            return Estimate.of((double)this.distribution.cumulativeProbability(value));
        }

        public Estimate inverseCumulativeProbability(double percentile) {
            if (percentile <= 0.0) {
                return Estimate.of((double)-10.0);
            }
            if (percentile >= 1.0) {
                return Estimate.of((double)10.0);
            }
            return Estimate.of((double)this.distribution.inverseCumulativeProbability(percentile));
        }

        public long getEstimatedSize() {
            return 0L;
        }
    }
}

