/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.DisjointRangeDomainHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistogramCalculator;
import com.facebook.presto.spi.statistics.UniformDistributionHistogram;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHistogramCalculator {
    @Test
    public void testCalculateFilterFactor() {
        Range zeroToTen = TestHistogramCalculator.range(0.0, 10.0);
        Range empty = Range.range((Type)DoubleType.DOUBLE, (Object)Double.NaN, (boolean)true, (Object)Double.NaN, (boolean)true);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), zeroToTen, 10.0, TestHistogramCalculator.uniformHist(0.0, 10.0), 5.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), zeroToTen, 10.0, TestHistogramCalculator.uniformHist(0.0, 10.0), 20.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.range(5.0, 3000.0), 5.0, TestHistogramCalculator.uniformHist(zeroToTen), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.1), TestHistogramCalculator.range(3.0, 3.0), 1.0, TestHistogramCalculator.uniformHist(zeroToTen), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.1), TestHistogramCalculator.range(10.0, 100.0), 357.0, TestHistogramCalculator.uniformHist(zeroToTen), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), TestHistogramCalculator.range(20.0, 30.0), 10.0, TestHistogramCalculator.uniformHist(zeroToTen), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), zeroToTen, 10.0, TestHistogramCalculator.uniformHist(empty), 0.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), empty, 0.0, TestHistogramCalculator.uniformHist(zeroToTen), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), TestHistogramCalculator.unboundedRange(), 10.0, TestHistogramCalculator.uniformHist(empty), 0.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.zero(), empty, 0.0, TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange()), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.unboundedRange(), 10.0, TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange()), 20.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)1.0), TestHistogramCalculator.unboundedRange(), 20.0, TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange()), 10.0);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.5), TestHistogramCalculator.unboundedRange(), 0.5, TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange()), Double.NaN);
        TestHistogramCalculator.assertFilterFactor(Estimate.of((double)0.2), TestHistogramCalculator.unboundedRange(), 1.0, TestHistogramCalculator.domainConstrained(TestHistogramCalculator.unboundedRange(), TestHistogramCalculator.uniformHist(TestHistogramCalculator.unboundedRange())), 5.0);
    }

    private static Range range(double low, double high) {
        return Range.range((Type)DoubleType.DOUBLE, (Object)low, (boolean)true, (Object)high, (boolean)true);
    }

    private static Range unboundedRange() {
        return Range.all((Type)DoubleType.DOUBLE);
    }

    private static void assertFilterFactor(Estimate expected, Range range, double distinctValues, ConnectorHistogram histogram, double totalDistinctValues) {
        Assert.assertEquals((Object)HistogramCalculator.calculateFilterFactor((Range)range, (double)distinctValues, (ConnectorHistogram)histogram, (Estimate)Estimate.estimateFromDouble((double)totalDistinctValues), (boolean)true), (Object)expected);
    }

    private static ConnectorHistogram uniformHist(Range range) {
        return TestHistogramCalculator.uniformHist(range.getLow().getObjectValue().map(Double.class::cast).orElse(Double.NEGATIVE_INFINITY), range.getHigh().getObjectValue().map(Double.class::cast).orElse(Double.POSITIVE_INFINITY));
    }

    private static ConnectorHistogram uniformHist(double low, double high) {
        return new UniformDistributionHistogram(low, high);
    }

    private static ConnectorHistogram domainConstrained(Range range, ConnectorHistogram source) {
        return DisjointRangeDomainHistogram.addDisjunction((ConnectorHistogram)source, (Range)range);
    }
}

