/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.spi.statistics.ConnectorHistogram;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TestHistogram;
import com.facebook.presto.spi.statistics.UniformDistributionHistogram;
import org.apache.commons.math3.distribution.RealDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUniformHistogram
extends TestHistogram {
    @Override
    ConnectorHistogram createHistogram() {
        return new UniformDistributionHistogram(0.0, 1.0);
    }

    @Override
    RealDistribution getDistribution() {
        return new UniformRealDistribution();
    }

    @Override
    double getDistinctValues() {
        return 100.0;
    }

    @Test
    public void testInvalidConstruction() {
        Assert.assertThrows(IllegalArgumentException.class, () -> new UniformDistributionHistogram(2.0, 1.0));
    }

    @Test
    public void testNanRangeValues() {
        UniformDistributionHistogram hist = new UniformDistributionHistogram(Double.NaN, 2.0);
        Assert.assertTrue((boolean)hist.inverseCumulativeProbability(0.5).isUnknown());
        hist = new UniformDistributionHistogram(1.0, Double.NaN);
        Assert.assertTrue((boolean)hist.inverseCumulativeProbability(0.5).isUnknown());
        hist = new UniformDistributionHistogram(1.0, 2.0);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.5).getValue(), (double)1.5);
    }

    @Test
    public void testInfiniteRangeValues() {
        UniformDistributionHistogram hist = new UniformDistributionHistogram(Double.NEGATIVE_INFINITY, 2.0);
        Assert.assertTrue((boolean)hist.inverseCumulativeProbability(0.5).isUnknown());
        Assert.assertEquals((Object)hist.inverseCumulativeProbability(0.0), (Object)Estimate.unknown());
        Assert.assertEquals((double)hist.inverseCumulativeProbability(1.0).getValue(), (double)2.0);
        Assert.assertEquals((Object)hist.cumulativeProbability(0.0, true), (Object)Estimate.unknown());
        Assert.assertEquals((Object)hist.cumulativeProbability(1.0, true), (Object)Estimate.unknown());
        Assert.assertEquals((double)hist.cumulativeProbability(2.0, true).getValue(), (double)1.0);
        Assert.assertEquals((double)hist.cumulativeProbability(2.5, true).getValue(), (double)1.0);
        hist = new UniformDistributionHistogram(1.0, Double.POSITIVE_INFINITY);
        Assert.assertTrue((boolean)hist.inverseCumulativeProbability(0.5).isUnknown());
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.0).getValue(), (double)1.0);
        Assert.assertEquals((Object)hist.inverseCumulativeProbability(1.0), (Object)Estimate.unknown());
        Assert.assertEquals((double)hist.cumulativeProbability(0.0, true).getValue(), (double)0.0);
        Assert.assertEquals((double)hist.cumulativeProbability(1.0, true).getValue(), (double)0.0);
        Assert.assertEquals((Object)hist.cumulativeProbability(1.5, true), (Object)Estimate.unknown());
    }

    @Test
    public void testSingleValueRange() {
        UniformDistributionHistogram hist = new UniformDistributionHistogram(1.0, 1.0);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.0).getValue(), (double)1.0);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(1.0).getValue(), (double)1.0);
        Assert.assertEquals((double)hist.inverseCumulativeProbability(0.5).getValue(), (double)1.0);
        Assert.assertEquals((double)hist.cumulativeProbability(0.0, true).getValue(), (double)0.0);
        Assert.assertEquals((double)hist.cumulativeProbability(0.5, true).getValue(), (double)0.0);
        Assert.assertEquals((double)hist.cumulativeProbability(1.0, true).getValue(), (double)1.0);
        Assert.assertEquals((double)hist.cumulativeProbability(1.5, true).getValue(), (double)1.0);
    }

    @Override
    public void testInclusiveExclusive() {
    }
}

