/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.PartitionedTableWritePolicy;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import java.util.List;
import java.util.Objects;

public class ConnectorNewTableLayout {
    private final ConnectorPartitioningHandle partitioning;
    private final List<String> partitionColumns;
    private final PartitionedTableWritePolicy writerPolicy;

    public ConnectorNewTableLayout(ConnectorPartitioningHandle partitioning, List<String> partitionColumns) {
        this(partitioning, partitionColumns, PartitionedTableWritePolicy.SINGLE_WRITER_PER_PARTITION_REQUIRED);
    }

    public ConnectorNewTableLayout(ConnectorPartitioningHandle partitioning, List<String> partitionColumns, PartitionedTableWritePolicy writerPolicy) {
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.writerPolicy = Objects.requireNonNull(writerPolicy, "writerPolicy is null");
    }

    public ConnectorPartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public PartitionedTableWritePolicy getWriterPolicy() {
        return this.writerPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorNewTableLayout that = (ConnectorNewTableLayout)o;
        return Objects.equals(this.partitioning, that.partitioning) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals((Object)this.writerPolicy, (Object)that.writerPolicy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitioning, this.partitionColumns, this.writerPolicy});
    }
}

