/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorNewTableLayout;
import com.facebook.presto.spi.PartitionedTableWritePolicy;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class NewTableLayout {
    private final ConnectorId connectorId;
    private final ConnectorTransactionHandle transactionHandle;
    private final ConnectorNewTableLayout layout;

    @JsonCreator
    public NewTableLayout(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="transactionHandle") ConnectorTransactionHandle transactionHandle, @JsonProperty(value="layout") ConnectorNewTableLayout layout) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.transactionHandle = Objects.requireNonNull(transactionHandle, "transactionHandle is null");
        this.layout = Objects.requireNonNull(layout, "layout is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorNewTableLayout getLayout() {
        return this.layout;
    }

    public PartitioningHandle getPartitioning() {
        return new PartitioningHandle(Optional.of(this.connectorId), Optional.of(this.transactionHandle), this.layout.getPartitioning());
    }

    public List<String> getPartitionColumns() {
        return this.layout.getPartitionColumns();
    }

    public PartitionedTableWritePolicy getWriterPolicy() {
        return this.layout.getWriterPolicy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewTableLayout that = (NewTableLayout)o;
        return Objects.equals(this.connectorId, that.connectorId) && Objects.equals(this.transactionHandle, that.transactionHandle) && Objects.equals(this.layout, that.layout);
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.transactionHandle, this.layout);
    }

    public String toString() {
        return String.format("%s {connectorId=%s, transactionHandle=%s, layout=%s}", this.getClass().getSimpleName(), this.connectorId, this.transactionHandle, this.layout);
    }
}

