/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public final class TableHandle {
    private final ConnectorId connectorId;
    private final ConnectorTableHandle connectorHandle;
    private final ConnectorTransactionHandle transaction;
    private final Optional<ConnectorTableLayoutHandle> layout;
    private final Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilter;

    @JsonCreator
    public TableHandle(@JsonProperty(value="connectorId") ConnectorId connectorId, @JsonProperty(value="connectorHandle") ConnectorTableHandle connectorHandle, @JsonProperty(value="transaction") ConnectorTransactionHandle transaction, @JsonProperty(value="connectorTableLayout") Optional<ConnectorTableLayoutHandle> layout) {
        this(connectorId, connectorHandle, transaction, layout, Optional.empty());
    }

    public TableHandle(ConnectorId connectorId, ConnectorTableHandle connectorHandle, ConnectorTransactionHandle transaction, Optional<ConnectorTableLayoutHandle> layout, Optional<Supplier<TupleDomain<ColumnHandle>>> dynamicFilter) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.connectorHandle = Objects.requireNonNull(connectorHandle, "connectorHandle is null");
        this.transaction = Objects.requireNonNull(transaction, "transaction is null");
        this.layout = Objects.requireNonNull(layout, "layout is null");
        this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
    }

    @JsonProperty
    public ConnectorId getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public ConnectorTableHandle getConnectorHandle() {
        return this.connectorHandle;
    }

    @JsonProperty
    public ConnectorTransactionHandle getTransaction() {
        return this.transaction;
    }

    @JsonProperty
    public Optional<ConnectorTableLayoutHandle> getLayout() {
        return this.layout;
    }

    public Optional<Supplier<TupleDomain<ColumnHandle>>> getDynamicFilter() {
        return this.dynamicFilter;
    }

    public TableHandle withDynamicFilter(Supplier<TupleDomain<ColumnHandle>> dynamicFilter) {
        Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        if (this.dynamicFilter.isPresent()) {
            throw new RuntimeException("dynamicFilter already exists");
        }
        return new TableHandle(this.connectorId, this.connectorHandle, this.transaction, this.layout, Optional.of(dynamicFilter));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TableHandle)) {
            return false;
        }
        TableHandle other = (TableHandle)obj;
        return Objects.equals(this.connectorId, other.connectorId) && Objects.equals(this.connectorHandle, other.connectorHandle) && Objects.equals(this.transaction, other.transaction) && Objects.equals(this.layout.isPresent(), other.layout.isPresent());
    }

    public int hashCode() {
        return Objects.hash(this.connectorId, this.connectorHandle, this.transaction, this.layout.isPresent());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("connectorId='").append(this.connectorId).append('\'');
        stringBuilder.append(", connectorHandle='").append(this.connectorHandle).append('\'');
        stringBuilder.append(", layout='").append(this.layout).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

