/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import java.util.List;

public class InvocationConvention {
    private final List<InvocationArgumentConvention> argumentConventionList;
    private final InvocationReturnConvention returnConvention;
    private final boolean hasSession;

    public InvocationConvention(List<InvocationArgumentConvention> argumentConventionList, InvocationReturnConvention returnConvention, boolean hasSession) {
        this.argumentConventionList = argumentConventionList;
        this.returnConvention = returnConvention;
        this.hasSession = hasSession;
    }

    public InvocationReturnConvention getReturnConvention() {
        return this.returnConvention;
    }

    public List<InvocationArgumentConvention> getArgumentConventions() {
        return this.argumentConventionList;
    }

    public InvocationArgumentConvention getArgumentConvention(int index) {
        return this.argumentConventionList.get(index);
    }

    public boolean hasSession() {
        return this.hasSession;
    }

    public String toString() {
        return "(" + this.argumentConventionList.toString() + ")" + (Object)((Object)this.returnConvention);
    }

    public static enum InvocationReturnConvention {
        FAIL_ON_NULL,
        NULLABLE_RETURN;

    }

    public static enum InvocationArgumentConvention {
        NEVER_NULL,
        BOXED_NULLABLE,
        NULL_FLAG,
        BLOCK_POSITION,
        FUNCTION;

    }
}

