/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.function;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.TypeVariableConstraint;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@ThriftStruct
public class SqlInvokedFunction
implements SqlFunction {
    private final List<Parameter> parameters;
    private final String description;
    private final RoutineCharacteristics routineCharacteristics;
    private final String body;
    private final boolean variableArity;
    private final Signature signature;
    private final SqlFunctionId functionId;
    private final FunctionVersion functionVersion;
    private final Optional<SqlFunctionHandle> functionHandle;
    private final Optional<AggregationFunctionMetadata> aggregationMetadata;

    @ThriftConstructor
    @JsonCreator
    public SqlInvokedFunction(@JsonProperty(value="parameters") List<Parameter> parameters, @JsonProperty(value="description") String description, @JsonProperty(value="routineCharacteristics") RoutineCharacteristics routineCharacteristics, @JsonProperty(value="body") String body, @JsonProperty(value="variableArity") boolean variableArity, @JsonProperty(value="signature") Signature signature, @JsonProperty(value="functionId") SqlFunctionId functionId) {
        this.parameters = parameters;
        this.description = description;
        this.routineCharacteristics = routineCharacteristics;
        this.body = body;
        this.signature = signature;
        this.variableArity = variableArity;
        this.functionId = functionId;
        this.functionVersion = FunctionVersion.notVersioned();
        this.functionHandle = Optional.empty();
        this.aggregationMetadata = Optional.empty();
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, FunctionVersion version) {
        this(functionName, parameters, Collections.emptyList(), returnType, description, routineCharacteristics, body, false, version, FunctionKind.SCALAR, Optional.empty());
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, FunctionVersion version, FunctionKind kind, Optional<AggregationFunctionMetadata> aggregationMetadata) {
        this(functionName, parameters, Collections.emptyList(), returnType, description, routineCharacteristics, body, false, version, kind, aggregationMetadata);
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, List<TypeVariableConstraint> typeVariableConstraints, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, boolean variableArity, FunctionVersion version, FunctionKind kind, Optional<AggregationFunctionMetadata> aggregationMetadata) {
        this(functionName, parameters, typeVariableConstraints, returnType, description, routineCharacteristics, body, variableArity, version, kind, new SqlFunctionId(functionName, SqlInvokedFunction.getArgumentTypes(parameters)), aggregationMetadata, version.hasVersion() ? Optional.of(new SqlFunctionHandle(new SqlFunctionId(functionName, SqlInvokedFunction.getArgumentTypes(parameters)), version.toString())) : Optional.empty());
    }

    public SqlInvokedFunction(QualifiedObjectName functionName, List<Parameter> parameters, List<TypeVariableConstraint> typeVariableConstraints, TypeSignature returnType, String description, RoutineCharacteristics routineCharacteristics, String body, boolean variableArity, FunctionVersion version, FunctionKind kind, SqlFunctionId functionId, Optional<AggregationFunctionMetadata> aggregationMetadata, Optional<SqlFunctionHandle> functionHandle) {
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.description = Objects.requireNonNull(description, "description is null");
        this.routineCharacteristics = Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null");
        this.body = Objects.requireNonNull(body, "body is null");
        this.signature = new Signature(functionName, kind, typeVariableConstraints, Collections.emptyList(), returnType, SqlInvokedFunction.getArgumentTypes(parameters), variableArity);
        this.functionId = Objects.requireNonNull(functionId, "functionId is null");
        this.variableArity = variableArity;
        this.functionVersion = Objects.requireNonNull(version, "version is null");
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        this.aggregationMetadata = Objects.requireNonNull(aggregationMetadata, "aggregationMetadata is null");
        SqlInvokedFunction.validateAggregationMetadata(kind, aggregationMetadata);
    }

    private static List<TypeSignature> getArgumentTypes(List<Parameter> parameters) {
        return parameters.stream().map(Parameter::getType).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static void validateAggregationMetadata(FunctionKind kind, Optional<AggregationFunctionMetadata> aggregationMetadata) {
        if (kind == FunctionKind.AGGREGATE && !aggregationMetadata.isPresent() || kind != FunctionKind.AGGREGATE && aggregationMetadata.isPresent()) {
            throw new IllegalArgumentException("aggregationMetadata must be present for aggregation functions and absent otherwise");
        }
    }

    public SqlInvokedFunction withVersion(String version) {
        if (this.hasVersion()) {
            throw new IllegalArgumentException(String.format("function %s is already with version %s", this.signature.getName(), this.getVersion()));
        }
        return new SqlInvokedFunction(this.signature.getName(), this.parameters, this.signature.getTypeVariableConstraints(), this.signature.getReturnType(), this.description, this.routineCharacteristics, this.body, this.variableArity, FunctionVersion.withVersion(version), this.signature.getKind(), this.aggregationMetadata);
    }

    @Override
    @ThriftField(value=1)
    @JsonProperty
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public SqlFunctionVisibility getVisibility() {
        return SqlFunctionVisibility.PUBLIC;
    }

    @Override
    public boolean isDeterministic() {
        return this.routineCharacteristics.isDeterministic();
    }

    @Override
    public boolean isCalledOnNullInput() {
        return this.routineCharacteristics.isCalledOnNullInput();
    }

    @Override
    @ThriftField(value=2)
    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @ThriftField(value=3)
    @JsonProperty
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @ThriftField(value=4)
    @JsonProperty
    public RoutineCharacteristics getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }

    @ThriftField(value=5)
    @JsonProperty
    public String getBody() {
        return this.body;
    }

    @ThriftField(value=6)
    @JsonProperty
    public SqlFunctionId getFunctionId() {
        return this.functionId;
    }

    public Optional<SqlFunctionHandle> getFunctionHandle() {
        return this.functionHandle;
    }

    public boolean hasVersion() {
        return this.functionVersion.hasVersion();
    }

    public FunctionVersion getVersion() {
        return this.functionVersion;
    }

    public boolean getVariableArity() {
        return this.variableArity;
    }

    public Optional<AggregationFunctionMetadata> getAggregationMetadata() {
        return this.aggregationMetadata;
    }

    public SqlFunctionHandle getRequiredFunctionHandle() {
        Optional<SqlFunctionHandle> functionHandle = this.getFunctionHandle();
        if (!functionHandle.isPresent()) {
            throw new IllegalStateException("missing functionHandle");
        }
        return functionHandle.get();
    }

    public String getRequiredVersion() {
        if (!this.hasVersion()) {
            throw new IllegalStateException("missing version");
        }
        return this.getVersion().toString();
    }

    public boolean hasSameDefinitionAs(SqlInvokedFunction function) {
        Objects.requireNonNull(function, "function is null");
        return Objects.equals(this.parameters, function.parameters) && Objects.equals(this.description, function.description) && Objects.equals(this.routineCharacteristics, function.routineCharacteristics) && Objects.equals(this.body, function.body) && Objects.equals(this.variableArity, function.variableArity) && Objects.equals(this.signature, function.signature) && Objects.equals(this.aggregationMetadata, function.aggregationMetadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlInvokedFunction o = (SqlInvokedFunction)obj;
        return Objects.equals(this.parameters, o.parameters) && Objects.equals(this.description, o.description) && Objects.equals(this.routineCharacteristics, o.routineCharacteristics) && Objects.equals(this.body, o.body) && Objects.equals(this.variableArity, o.variableArity) && Objects.equals(this.signature, o.signature) && Objects.equals(this.functionId, o.functionId) && Objects.equals(this.functionHandle, o.functionHandle) && Objects.equals(this.aggregationMetadata, o.aggregationMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.description, this.routineCharacteristics, this.body, this.variableArity, this.signature, this.functionId, this.functionHandle);
    }

    public String toString() {
        return String.format("%s(%s):%s%s [%s%s] {%s} %s", new Object[]{this.signature.getName(), this.parameters.stream().map(Object::toString).collect(Collectors.joining(",")), this.signature.getReturnType(), this.hasVersion() ? ":" + this.getVersion() : "", this.signature.getKind(), this.signature.getKind() == FunctionKind.AGGREGATE ? ", " + this.getAggregationMetadata().get() : "", this.body, this.routineCharacteristics, this.variableArity});
    }
}

