/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.common.Utils;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.plan.InputDistribution;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DeleteNode
extends PlanNode {
    private final PlanNode source;
    private final VariableReferenceExpression rowId;
    private final List<VariableReferenceExpression> outputVariables;
    private final Optional<InputDistribution> inputDistribution;

    @JsonCreator
    public DeleteNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="rowId") VariableReferenceExpression rowId, @JsonProperty(value="outputVariables") List<VariableReferenceExpression> outputVariables, @JsonProperty(value="inputDistribution") Optional<InputDistribution> inputDistribution) {
        this(sourceLocation, id, Optional.empty(), source, rowId, outputVariables, inputDistribution);
    }

    public DeleteNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, VariableReferenceExpression rowId, List<VariableReferenceExpression> outputVariables, Optional<InputDistribution> inputDistribution) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        this.source = Objects.requireNonNull(source, "source is null");
        this.rowId = Objects.requireNonNull(rowId, "rowId is null");
        this.outputVariables = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(outputVariables, "outputVariables is null")));
        this.inputDistribution = Objects.requireNonNull(inputDistribution, "dataPartition is null");
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public VariableReferenceExpression getRowId() {
        return this.rowId;
    }

    @Override
    @JsonProperty
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.outputVariables;
    }

    @JsonProperty
    public Optional<InputDistribution> getInputDistribution() {
        return this.inputDistribution;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDelete(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Utils.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0);
        return new DeleteNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.rowId, this.outputVariables, this.inputDistribution);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new DeleteNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.rowId, this.outputVariables, this.inputDistribution);
    }
}

