/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SourceLocation;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.plan.LogicalProperties;
import com.facebook.presto.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LimitNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final Step step;

    @JsonCreator
    public LimitNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="step") Step step) {
        this(sourceLocation, id, Optional.empty(), source, count, step);
    }

    public LimitNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, long count, Step step) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        LimitNode.checkCondition(count >= 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count must be greater than or equal to zero");
        this.source = Objects.requireNonNull(source, "source is null");
        this.count = count;
        this.step = Objects.requireNonNull(step, "step is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public Step getStep() {
        return this.step;
    }

    public boolean isPartial() {
        return this.step == Step.PARTIAL;
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getLimitProperties(this);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new LimitNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.count, this.getStep());
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        LimitNode.checkCondition(newChildren != null && newChildren.size() == 1, StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expect exactly 1 child PlanNode");
        return new LimitNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.count, this.getStep());
    }

    private static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String message) {
        if (!condition) {
            throw new PrestoException(errorCode, message);
        }
    }

    public static enum Step {
        PARTIAL,
        FINAL;

    }
}

